/*
 * Decompiled with CFR 0.152.
 */
package net.lulaboludo.createornithopterglider.integration.jei;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.lulaboludo.createornithopterglider.item.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class OrnithopterJeiPlugin
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("createornithopterglider", "jei_plugin");
    public static final ResourceLocation WING_MESH_REPAIR = new ResourceLocation("createornithopterglider", "wing_mesh_repair");
    public static final ResourceLocation GLIDER_SELF_REPAIR = new ResourceLocation("createornithopterglider", "glider_self_repair");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        this.registerGlidersAnvilRepairs(registration, factory);
    }

    private void registerGlidersAnvilRepairs(@NotNull IRecipeRegistration registration, @NotNull IVanillaRecipeFactory factory) {
        ModItems.ORNITHOPTER_ITEMS.forEach((color, gliderRegistry) -> {
            Item glider = (Item)gliderRegistry.get();
            Item wingMesh = (Item)ModItems.WING_MESHES.get(color).get();
            ItemStack brokenGlider = OrnithopterJeiPlugin.brokenItem(glider);
            ItemStack damagedGlider = OrnithopterJeiPlugin.damagedItem(glider);
            ItemStack partialRepairedGlider = OrnithopterJeiPlugin.partialRepairedItem(glider);
            IJeiAnvilRecipe wingMeshRepair = factory.createAnvilRecipe(brokenGlider, Collections.singletonList(new ItemStack((ItemLike)wingMesh)), Collections.singletonList(damagedGlider), WING_MESH_REPAIR);
            IJeiAnvilRecipe gliderSelfRepair = factory.createAnvilRecipe(damagedGlider, Collections.singletonList(damagedGlider.m_41777_()), Collections.singletonList(partialRepairedGlider), GLIDER_SELF_REPAIR);
            registration.addRecipes(RecipeTypes.ANVIL, List.of(wingMeshRepair, gliderSelfRepair));
        });
    }

    private static ItemStack brokenItem(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.m_41721_(stack.m_41776_());
        return stack;
    }

    private static ItemStack damagedItem(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.m_41721_(stack.m_41776_() * 3 / 4);
        return stack;
    }

    private static ItemStack partialRepairedItem(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.m_41721_(stack.m_41776_() * 2 / 4);
        return stack;
    }
}

