/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.input;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Vector;
import org.lwjgl.glfw.GLFW;

public class JoystickInputs {
    private static Vector<Boolean> buttons = new Vector(0);
    private static Vector<Float> axis = new Vector(0);
    private static Vector<Float> storedAxis = new Vector(0);
    protected static int selectedJoystick = -1;

    public static void GetControls() {
        if (selectedJoystick < 0) {
            int uniqueJoystickID = -1;
            block0: for (int i = 0; i < 16 && selectedJoystick < 0; ++i) {
                if (!GLFW.glfwJoystickPresent((int)i)) continue;
                if (uniqueJoystickID == -1) {
                    uniqueJoystickID = i;
                } else if (uniqueJoystickID >= 0) {
                    uniqueJoystickID = -2;
                }
                ByteBuffer res = GLFW.glfwGetJoystickButtons((int)i);
                if (res == null) continue;
                for (int b = 0; b < res.limit(); ++b) {
                    if (res.get(b) != 1) continue;
                    JoystickInputs.SelectJoystick(i);
                    continue block0;
                }
            }
            if (selectedJoystick < 0 && uniqueJoystickID >= 0) {
                JoystickInputs.SelectJoystick(uniqueJoystickID);
            }
        }
        if (selectedJoystick >= 0 && GLFW.glfwJoystickPresent((int)selectedJoystick)) {
            ByteBuffer b = GLFW.glfwGetJoystickButtons((int)selectedJoystick);
            FloatBuffer a = GLFW.glfwGetJoystickAxes((int)selectedJoystick);
            if (b == null || buttons.size() != b.limit() || a == null || axis.size() != a.limit()) {
                JoystickInputs.Empty();
                selectedJoystick = -1;
            } else {
                JoystickInputs.Fill(b, a);
            }
        } else {
            JoystickInputs.Empty();
            selectedJoystick = -1;
        }
    }

    private static void SelectJoystick(int id) {
        selectedJoystick = id;
        ByteBuffer b = GLFW.glfwGetJoystickButtons((int)selectedJoystick);
        buttons = new Vector(b.limit());
        for (int i = 0; i < b.limit(); ++i) {
            buttons.add(false);
        }
        FloatBuffer a = GLFW.glfwGetJoystickAxes((int)selectedJoystick);
        axis = new Vector(a.limit());
        storedAxis = new Vector(a.limit());
        for (int i = 0; i < a.limit(); ++i) {
            axis.add(Float.valueOf(0.0f));
            storedAxis.add(Float.valueOf(0.0f));
        }
    }

    public static int GetButtonCount() {
        return JoystickInputs.HasJoystick() ? buttons.size() : 0;
    }

    public static int GetAxisCount() {
        return JoystickInputs.HasJoystick() ? axis.size() : 0;
    }

    public static int GetJoystickIndex() {
        return selectedJoystick;
    }

    public static boolean HasJoystick() {
        return selectedJoystick >= 0;
    }

    public static void SearchGamepad() {
        selectedJoystick = -1;
    }

    public static boolean GetButton(int button) {
        return button >= JoystickInputs.GetButtonCount() ? false : buttons.get(button);
    }

    public static float GetAxis(int axis) {
        return axis >= JoystickInputs.GetAxisCount() ? 0.0f : JoystickInputs.axis.get(axis).floatValue();
    }

    public static void Empty() {
        int i;
        for (i = 0; i < buttons.size(); ++i) {
            buttons.set(i, false);
        }
        for (i = 0; i < axis.size(); ++i) {
            axis.set(i, Float.valueOf(0.0f));
        }
    }

    public static void Fill(ByteBuffer b, FloatBuffer a) {
        int i;
        for (i = 0; i < b.limit(); ++i) {
            buttons.set(i, b.get(i) == 1);
        }
        for (i = 0; i < a.limit(); ++i) {
            axis.set(i, Float.valueOf(a.get(i)));
        }
    }

    public static void StoreAxisValues() {
        for (int i = 0; i < axis.size(); ++i) {
            storedAxis.set(i, axis.get(i));
        }
    }

    public static int GetFirstButton() {
        for (int i = 0; i < buttons.size(); ++i) {
            if (!buttons.get(i).booleanValue()) continue;
            return i;
        }
        return -1;
    }

    public static int GetFirstAxis() {
        for (int i = 0; i < axis.size(); ++i) {
            if (!(Math.abs(axis.get(i).floatValue() - storedAxis.get(i).floatValue()) > 0.75f)) continue;
            return i;
        }
        return -1;
    }

    public static float GetStoredAxis(int index) {
        return storedAxis.get(index).floatValue();
    }
}

