/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.registry.JEI;

import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.BlueprintTransferHandler;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.dakotapride.garnished.GarnishedLang;
import net.dakotapride.garnished.recipe.BlackDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.BlueDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.BrownDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.CyanDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.FreezingFanRecipe;
import net.dakotapride.garnished.recipe.GrayDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.GreenDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.LightBlueDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.LightGrayDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.LimeDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.MagentaDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.OrangeDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.PinkDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.PurpleDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.RedDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.WhiteDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.YellowDyeBlowingFanRecipe;
import net.dakotapride.garnished.registry.GarnishedFluids;
import net.dakotapride.garnished.registry.GarnishedItems;
import net.dakotapride.garnished.registry.GarnishedRecipeTypes;
import net.dakotapride.garnished.registry.JEI.BlackDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.BlueDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.BrownDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.CyanDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.FreezingFanCategory;
import net.dakotapride.garnished.registry.JEI.GrayDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.GreenDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.LightBlueDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.LightGrayDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.LimeDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.MagentaDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.OrangeDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.PinkDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.PurpleDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.RedDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.WhiteDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.YellowDyeBlowingFanCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.ForgeFlowingFluid;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class GarnishedJEI
implements IModPlugin {
    private static final ResourceLocation MOD_ID = new ResourceLocation("garnished", "jei_plugin");
    public IIngredientManager ingredientManager;
    private static final List<CreateRecipeCategory<?>> Categories = new ArrayList();

    @Nonnull
    public ResourceLocation getPluginUid() {
        return MOD_ID;
    }

    private void loadCategories() {
        Categories.clear();
        CreateRecipeCategory freezing = this.builder(FreezingFanRecipe.class).addTypedRecipes(GarnishedRecipeTypes.FREEZING::getType).catalystStack(ProcessingViaFanCategory.getFan((String)"garnished.fan_freezing")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_151055_).emptyBackground(178, 72).build("garnished.fan_freezing", FreezingFanCategory::new);
        CreateRecipeCategory<RedDyeBlowingFanRecipe> redDyeBlowing = this.dyeBlowingCategory(RedDyeBlowingFanRecipe.class, GarnishedRecipeTypes.RED_DYE_BLOWING, "garnished.red_dye_blowing", GarnishedFluids.RED_MASTIC_RESIN).build("garnished.red_dye_blowing", (CreateRecipeCategory.Factory<RedDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)RedDyeBlowingFanCategory::new));
        CreateRecipeCategory<OrangeDyeBlowingFanRecipe> orangeDyeBlowing = this.dyeBlowingCategory(OrangeDyeBlowingFanRecipe.class, GarnishedRecipeTypes.ORANGE_DYE_BLOWING, "garnished.orange_dye_blowing", GarnishedFluids.ORANGE_MASTIC_RESIN).build("garnished.orange_dye_blowing", (CreateRecipeCategory.Factory<OrangeDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)OrangeDyeBlowingFanCategory::new));
        CreateRecipeCategory<YellowDyeBlowingFanRecipe> yellowDyeBlowing = this.dyeBlowingCategory(YellowDyeBlowingFanRecipe.class, GarnishedRecipeTypes.YELLOW_DYE_BLOWING, "garnished.yellow_dye_blowing", GarnishedFluids.YELLOW_MASTIC_RESIN).build("garnished.yellow_dye_blowing", (CreateRecipeCategory.Factory<YellowDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)YellowDyeBlowingFanCategory::new));
        CreateRecipeCategory<GreenDyeBlowingFanRecipe> greenDyeBlowing = this.dyeBlowingCategory(GreenDyeBlowingFanRecipe.class, GarnishedRecipeTypes.GREEN_DYE_BLOWING, "garnished.green_dye_blowing", GarnishedFluids.GREEN_MASTIC_RESIN).build("garnished.green_dye_blowing", (CreateRecipeCategory.Factory<GreenDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)GreenDyeBlowingFanCategory::new));
        CreateRecipeCategory<LimeDyeBlowingFanRecipe> limeDyeBlowing = this.dyeBlowingCategory(LimeDyeBlowingFanRecipe.class, GarnishedRecipeTypes.LIME_DYE_BLOWING, "garnished.lime_dye_blowing", GarnishedFluids.LIME_MASTIC_RESIN).build("garnished.lime_dye_blowing", (CreateRecipeCategory.Factory<LimeDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)LimeDyeBlowingFanCategory::new));
        CreateRecipeCategory<BlueDyeBlowingFanRecipe> blueDyeBlowing = this.dyeBlowingCategory(BlueDyeBlowingFanRecipe.class, GarnishedRecipeTypes.BLUE_DYE_BLOWING, "garnished.blue_dye_blowing", GarnishedFluids.BLUE_MASTIC_RESIN).build("garnished.blue_dye_blowing", (CreateRecipeCategory.Factory<BlueDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)BlueDyeBlowingFanCategory::new));
        CreateRecipeCategory<LightBlueDyeBlowingFanRecipe> lightBlueDyeBlowing = this.dyeBlowingCategory(LightBlueDyeBlowingFanRecipe.class, GarnishedRecipeTypes.LIGHT_BLUE_DYE_BLOWING, "garnished.light_blue_dye_blowing", GarnishedFluids.LIGHT_BLUE_MASTIC_RESIN).build("garnished.light_blue_dye_blowing", (CreateRecipeCategory.Factory<LightBlueDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)LightBlueDyeBlowingFanCategory::new));
        CreateRecipeCategory<CyanDyeBlowingFanRecipe> cyanDyeBlowing = this.dyeBlowingCategory(CyanDyeBlowingFanRecipe.class, GarnishedRecipeTypes.CYAN_DYE_BLOWING, "garnished.cyan_dye_blowing", GarnishedFluids.CYAN_MASTIC_RESIN).build("garnished.cyan_dye_blowing", (CreateRecipeCategory.Factory<CyanDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)CyanDyeBlowingFanCategory::new));
        CreateRecipeCategory<PurpleDyeBlowingFanRecipe> purpleDyeBlowing = this.dyeBlowingCategory(PurpleDyeBlowingFanRecipe.class, GarnishedRecipeTypes.PURPLE_DYE_BLOWING, "garnished.purple_dye_blowing", GarnishedFluids.PURPLE_MASTIC_RESIN).build("garnished.purple_dye_blowing", (CreateRecipeCategory.Factory<PurpleDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)PurpleDyeBlowingFanCategory::new));
        CreateRecipeCategory<MagentaDyeBlowingFanRecipe> magentaDyeBlowing = this.dyeBlowingCategory(MagentaDyeBlowingFanRecipe.class, GarnishedRecipeTypes.MAGENTA_DYE_BLOWING, "garnished.magenta_dye_blowing", GarnishedFluids.MAGENTA_MASTIC_RESIN).build("garnished.magenta_dye_blowing", (CreateRecipeCategory.Factory<MagentaDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)MagentaDyeBlowingFanCategory::new));
        CreateRecipeCategory<PinkDyeBlowingFanRecipe> pinkDyeBlowing = this.dyeBlowingCategory(PinkDyeBlowingFanRecipe.class, GarnishedRecipeTypes.PINK_DYE_BLOWING, "garnished.pink_dye_blowing", GarnishedFluids.PINK_MASTIC_RESIN).build("garnished.pink_dye_blowing", (CreateRecipeCategory.Factory<PinkDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)PinkDyeBlowingFanCategory::new));
        CreateRecipeCategory<BlackDyeBlowingFanRecipe> blackDyeBlowing = this.dyeBlowingCategory(BlackDyeBlowingFanRecipe.class, GarnishedRecipeTypes.BLACK_DYE_BLOWING, "garnished.black_dye_blowing", GarnishedFluids.BLACK_MASTIC_RESIN).build("garnished.black_dye_blowing", (CreateRecipeCategory.Factory<BlackDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)BlackDyeBlowingFanCategory::new));
        CreateRecipeCategory<GrayDyeBlowingFanRecipe> grayDyeBlowing = this.dyeBlowingCategory(GrayDyeBlowingFanRecipe.class, GarnishedRecipeTypes.GRAY_DYE_BLOWING, "garnished.gray_dye_blowing", GarnishedFluids.GRAY_MASTIC_RESIN).build("garnished.gray_dye_blowing", (CreateRecipeCategory.Factory<GrayDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)GrayDyeBlowingFanCategory::new));
        CreateRecipeCategory<LightGrayDyeBlowingFanRecipe> lightGrayDyeBlowing = this.dyeBlowingCategory(LightGrayDyeBlowingFanRecipe.class, GarnishedRecipeTypes.LIGHT_GRAY_DYE_BLOWING, "garnished.light_gray_dye_blowing", GarnishedFluids.LIGHT_GRAY_MASTIC_RESIN).build("garnished.light_gray_dye_blowing", (CreateRecipeCategory.Factory<LightGrayDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)LightGrayDyeBlowingFanCategory::new));
        CreateRecipeCategory<WhiteDyeBlowingFanRecipe> whiteDyeBlowing = this.dyeBlowingCategory(WhiteDyeBlowingFanRecipe.class, GarnishedRecipeTypes.WHITE_DYE_BLOWING, "garnished.white_dye_blowing", GarnishedFluids.WHITE_MASTIC_RESIN).build("garnished.white_dye_blowing", (CreateRecipeCategory.Factory<WhiteDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)WhiteDyeBlowingFanCategory::new));
        CreateRecipeCategory<BrownDyeBlowingFanRecipe> brownDyeBlowing = this.dyeBlowingCategory(BrownDyeBlowingFanRecipe.class, GarnishedRecipeTypes.BROWN_DYE_BLOWING, "garnished.brown_dye_blowing", GarnishedFluids.BROWN_MASTIC_RESIN).build("garnished.brown_dye_blowing", (CreateRecipeCategory.Factory<BrownDyeBlowingFanRecipe>)((CreateRecipeCategory.Factory)BrownDyeBlowingFanCategory::new));
    }

    public <T extends Recipe<?>> CategoryBuilder<T> dyeBlowingCategory(Class<T> recipe, GarnishedRecipeTypes types, String name, FluidEntry<ForgeFlowingFluid.Flowing> fluidEntry) {
        return this.builder(recipe).addTypedRecipes(types::getType).catalystStack(ProcessingViaFanCategory.getFan((String)name)).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)fluidEntry.getBucket().get()).emptyBackground(178, 72);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        Categories.forEach(c -> c.registerRecipes(registration));
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.ENFLAMED_MANDIBLE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.enflamed_mandible.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.GHAST_TENDRIL.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.ghast_tendril.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.MOLTEN_REMNANT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.molten_remnant.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.RAW_POLAR_BEAR_MEAT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.polar_bear_meat.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.POLAR_BEAR_HIDE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.polar_bear_hide.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.NUMBING_PARCHMENT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.stray_parchment.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.RAW_TENEBROUS_MEAT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.tenebrous_meat.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.TUSK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.tusk.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.IRATE_TUSK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.irate_tusk.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.DIMMED_SCALE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.ender_scale.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.PRELIMINARY_NUCLEUS.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.endermite_heart.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.MEAT_SCRAPS.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.ravager_meat.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.VEX_WING.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.garnished.vex_wing.information")});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])Categories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "sandpaper_polishing")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)GarnishedItems.POLAR_HIDE_SCRATCH_PAPER.get()), new RecipeType[]{type}));
        Categories.forEach(c -> c.registerCatalysts(registration));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BlueprintTransferHandler(), RecipeTypes.CRAFTING);
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    public static void consumeAllRecipes(Consumer<Recipe<?>> consumer) {
        Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_105141_().m_44051_().forEach(consumer);
    }

    private static class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<CRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> enableIf(Predicate<CRecipes> predicate) {
            this.predicate = predicate;
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<CRecipes, Object> configValue) {
            this.predicate = c -> (Boolean)configValue.apply((CRecipes)c);
            return this;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
            return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> GarnishedJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> GarnishedJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
                }
            }));
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> recipes.add((Recipe)converter.apply((Recipe<?>)recipe)), (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesIf(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesExcluding(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> excluded) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = CategoryBuilder.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)excluded.get());
                CreateJEI.consumeTypedRecipes(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CategoryBuilder.doInputsMatch(recipe, excludedRecipe)) continue;
                        return;
                    }
                    recipes.add(recipe);
                }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
            });
        }

        public CategoryBuilder<T> removeRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = CategoryBuilder.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)recipeType.get());
                recipes.removeIf(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CategoryBuilder.doInputsMatch(recipe, excludedRecipe)) continue;
                        return true;
                    }
                    return false;
                });
            });
        }

        public static List<Recipe<?>> getTypedRecipes(net.minecraft.world.item.crafting.RecipeType<?> type) {
            ArrayList recipes = new ArrayList();
            CreateJEI.consumeTypedRecipes(recipes::add, type);
            return recipes;
        }

        public static List<Recipe<?>> getTypedRecipesExcluding(net.minecraft.world.item.crafting.RecipeType<?> type, Predicate<Recipe<?>> exclusionPred) {
            List<Recipe<?>> recipes = CategoryBuilder.getTypedRecipes(type);
            recipes.removeIf(exclusionPred);
            return recipes;
        }

        public static boolean doInputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
            if (recipe1.m_7527_().isEmpty() || recipe2.m_7527_().isEmpty()) {
                return false;
            }
            ItemStack[] matchingStacks = ((Ingredient)recipe1.m_7527_().get(0)).m_43908_();
            if (matchingStacks.length == 0) {
                return false;
            }
            return ((Ingredient)recipe2.m_7527_().get(0)).test(matchingStacks[0]);
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : Collections::emptyList;
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(Create.asResource((String)name), this.recipeClass), (Component)GarnishedLang.translateDirect("recipe." + name, new Object[0]), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory category = factory.create(info);
            Categories.add(category);
            return category;
        }
    }
}

