/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.mixin;

import java.util.Objects;
import net.dakotapride.garnished.item.hatchet.HatchetUtils;
import net.dakotapride.garnished.registry.GarnishedAdvancementUtils;
import net.dakotapride.garnished.registry.GarnishedEffects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    LivingEntity entity = (LivingEntity)this;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tickEffects"}, at={@At(value="HEAD")})
    private void spiritedResistanceImmunity$tickEffects(CallbackInfo ci) {
        if (this.entity.m_21023_((MobEffect)GarnishedEffects.SPIRITED_RESISTANCE.get())) {
            if (this.entity.m_21023_(MobEffects.f_19615_)) {
                this.entity.m_21195_(MobEffects.f_19615_);
            }
            if (this.entity.m_21023_(MobEffects.f_19604_)) {
                this.entity.m_21195_(MobEffects.f_19604_);
            }
            if (this.entity.m_21023_(MobEffects.f_19610_)) {
                this.entity.m_21195_(MobEffects.f_19610_);
            }
        }
        if (HatchetUtils.canApplyRavagingEffects(this.entity)) {
            this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 1));
        }
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="HEAD")})
    private void spiritedResistanceThorns$getDamageAfterMagicAbsorb(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            boolean isSkeleton = attacker instanceof Skeleton;
            boolean isWitherSkeleton = attacker instanceof WitherSkeleton;
            boolean isWither = attacker instanceof WitherBoss;
            boolean isGhast = attacker instanceof Ghast;
            if (this.entity.m_21023_((MobEffect)GarnishedEffects.SPIRITED_RESISTANCE.get()) && (isSkeleton || isWitherSkeleton || isWither || isGhast)) {
                attacker.m_6469_(source, amount * 1.336745f);
            }
        }
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="HEAD")})
    private void applyThornsDamage$getDamageAfterMagicAbsorb(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            float j = amount / 2.0f;
            boolean f = j <= 3.0f;
            MobEffect e = (MobEffect)GarnishedEffects.THORNS.get();
            if (f) {
                j = 4.0f;
            }
            if (this.entity.m_21023_(e) && !attacker.m_21023_(e)) {
                attacker.m_6469_(source, j);
            } else if (j > attacker.m_21233_() * 0.8f && this.entity.m_21023_(e) && !attacker.m_21023_(e)) {
                attacker.m_6469_(source, attacker.m_21233_() * 0.8f);
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void negateArrowDamage$hurt(DamageSource pSource, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        int j;
        int k;
        MobEffect truthSeekerMobEffect;
        int effectAmplifier;
        int boundInt;
        int negateChance;
        if (this.entity.m_21023_((MobEffect)GarnishedEffects.TRUTH_SEEKER.get()) && pSource.m_7640_() instanceof AbstractArrow && this.entity.m_21124_((MobEffect)GarnishedEffects.TRUTH_SEEKER.get()) != null && (negateChance = (boundInt = 20 - (effectAmplifier = Objects.requireNonNull(this.entity.m_21124_(truthSeekerMobEffect = (MobEffect)GarnishedEffects.TRUTH_SEEKER.get())).m_19564_())) <= 0 ? this.entity.m_217043_().m_188503_(1) : this.entity.m_217043_().m_188503_(boundInt + 1)) <= (k = (j = this.entity.m_217043_().m_188503_(10)) + 10)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void dejojoAdvancement(CallbackInfo ci) {
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (this.m_20149_().equals("7282ae0d-c2f5-4610-8be9-70af5a1322a4")) {
                GarnishedAdvancementUtils.DEJOJO.trigger(player);
            }
        }
    }
}

