/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.parties.party.PartyManager;
import xaero.pac.common.server.parties.party.ServerParty;

public final class PartyManagerFixer {
    public void fix(PartyManager partyManager) {
        OpenPartiesAndClaims.LOGGER.info("Fixing party inconsistencies...");
        ArrayList partiesToRemove = new ArrayList();
        partyManager.getTypedAllStream().forEach(party -> {
            ArrayList membersToRemove = new ArrayList();
            party.getTypedMemberInfoStream().forEach(p -> this.fixPlayer((ServerParty)party, partyManager, (PartyMember)p, partiesToRemove, membersToRemove));
            membersToRemove.forEach(party::removeMember);
        });
        partiesToRemove.forEach(partyManager::removeTypedParty);
    }

    private void fixPlayer(ServerParty fixingParty, PartyManager partyManager, PartyMember player, List<ServerParty> partiesToRemove, List<UUID> membersToRemove) {
        UUID playerId = player.getUUID();
        ServerParty correctParty = partyManager.getPartyByMember(playerId);
        if (correctParty == fixingParty) {
            return;
        }
        if (fixingParty.getOwner().getUUID().equals(playerId)) {
            partiesToRemove.add(fixingParty);
            return;
        }
        membersToRemove.add(player.getUUID());
    }
}

