/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.handrails;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.platform.EnvExecute;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;

public class HandrailBlockEntity
extends SmartBlockEntity {
    public int width = 1;
    public boolean propagateBreak = true;
    private DyeColor handrailColor = null;

    public HandrailBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public float getSpeed() {
        float f;
        BlockEntity blockEntity;
        if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_())) instanceof WalkwayBlockEntity) {
            WalkwayBlockEntity walkway = (WalkwayBlockEntity)blockEntity;
            f = walkway.getWalkwayMovementSpeed();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public float getVisualProgress() {
        float f;
        BlockEntity blockEntity;
        if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_())) instanceof WalkwayBlockEntity) {
            WalkwayBlockEntity walkway = (WalkwayBlockEntity)blockEntity;
            f = walkway.getVisualProgress();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public boolean setHandrailColor(@Nullable DyeColor colorIn) {
        Direction offsetDir;
        BlockEntity blockEntity;
        if (colorIn == this.handrailColor) {
            return false;
        }
        if (this.f_58857_.f_46443_) {
            return true;
        }
        int MAX_ITER = 1100;
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)AbstractHandrailBlock.f_54117_);
        Direction left = facing.m_122428_();
        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)this.m_58900_().m_61143_(AbstractHandrailBlock.SIDE));
        this.handrailColor = colorIn;
        this.notifyUpdate();
        BlockPos offset = BlockPos.f_121853_;
        if (this.width > 1 && (blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)(offset = BlockPos.f_121853_.m_5484_(offsetDir = side == AbstractHandrailBlock.Side.LEFT ? left.m_122424_() : left, this.width - 1))))) instanceof HandrailBlockEntity) {
            HandrailBlockEntity other = (HandrailBlockEntity)blockEntity;
            other.handrailColor = colorIn;
            other.notifyUpdate();
        }
        for (boolean forward : Iterate.trueAndFalse) {
            BlockPos iterPos = this.f_58858_;
            BlockState iterState = this.m_58900_();
            for (int i = 0; i < MAX_ITER && (iterPos = AbstractHandrailBlock.nextSegmentPosition(iterState, iterPos, forward)) != null && (iterState = this.f_58857_.m_8055_(iterPos)).m_60734_() instanceof AbstractHandrailBlock; ++i) {
                HandrailBlockEntity other;
                BlockEntity blockEntity2 = this.f_58857_.m_7702_(iterPos);
                if (blockEntity2 instanceof HandrailBlockEntity) {
                    other = (HandrailBlockEntity)blockEntity2;
                    other.handrailColor = colorIn;
                    other.notifyUpdate();
                }
                if (this.width <= 1 || !((blockEntity2 = this.f_58857_.m_7702_(iterPos.m_121955_((Vec3i)offset))) instanceof HandrailBlockEntity)) continue;
                other = (HandrailBlockEntity)blockEntity2;
                other.handrailColor = colorIn;
                other.notifyUpdate();
            }
        }
        return true;
    }

    @Nullable
    public DyeColor getHandrailColor() {
        return this.handrailColor;
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.width = tag.m_128451_("Width");
        DyeColor dyeColor = this.handrailColor = tag.m_128425_("Dye", 8) ? (DyeColor)NBTHelper.readEnum((CompoundTag)tag, (String)"Dye", DyeColor.class) : null;
        if (clientPacket) {
            EnvExecute.executeOnClient(() -> () -> VisualizationHelper.queueUpdate((BlockEntity)this));
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128405_("Width", this.width);
        if (this.handrailColor != null) {
            NBTHelper.writeEnum((CompoundTag)tag, (String)"Dye", (Enum)this.handrailColor);
        }
    }
}

