/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.core.advancement;

import com.petrolpark.data.advancement.SimpleAdvancementTrigger;
import com.petrolpark.petrolsparts.PetrolsParts;
import com.petrolpark.util.Lang;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public enum PetrolsPartsAdvancementTrigger {
    COAXIAL_GEAR,
    COLOSSAL_COGWHEEL_POWER_MANY,
    DIFFERENTIAL,
    PNEUMATIC_TUBE;

    private String triggerId = Lang.asId((String)this.name());
    private String[] advancementIds = new String[]{Lang.asId((String)this.name())};
    private SimpleAdvancementTrigger trigger = new SimpleAdvancementTrigger(PetrolsParts.asResource(this.triggerId));

    public void award(Level level, Player player) {
        if (level.m_5776_()) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.trigger.trigger(serverPlayer);
        } else {
            PetrolsParts.LOGGER.warn("Could not award Destroy Advancement " + this.triggerId + " to client-side Player.");
        }
    }

    public boolean isAlreadyAwardedTo(LivingEntity player) {
        if (!(player instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer sp = (ServerPlayer)player;
        for (String advancementId : this.advancementIds) {
            Advancement advancement = sp.m_20194_().m_129889_().m_136041_(PetrolsParts.asResource(advancementId));
            if (advancement != null && !sp.m_8960_().m_135996_(advancement).m_8193_()) continue;
            return true;
        }
        return false;
    }

    public static void register() {
        for (PetrolsPartsAdvancementTrigger e : PetrolsPartsAdvancementTrigger.values()) {
            CriteriaTriggers.m_10595_((CriterionTrigger)e.trigger);
        }
    }
}

