/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.coaxial_gear;

import com.petrolpark.petrolsparts.PetrolsPartsBlockEntityTypes;
import com.petrolpark.petrolsparts.PetrolsPartsBlocks;
import com.petrolpark.petrolsparts.content.coaxial_gear.CoaxialGearBlock;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementBehaviour;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementTrigger;
import com.petrolpark.petrolsparts.core.block.DirectionalRotatedPillarKineticBlock;
import com.petrolpark.util.KineticsHelper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CoaxialGearBlockEntity
extends BracketedKineticBlockEntity {
    protected PetrolsPartsAdvancementBehaviour advancementBehaviour;

    public CoaxialGearBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.advancementBehaviour = new PetrolsPartsAdvancementBehaviour((SmartBlockEntity)this, PetrolsPartsAdvancementTrigger.COAXIAL_GEAR);
        behaviours.add((BlockEntityBehaviour)this.advancementBehaviour);
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        IRotate iRotate;
        Block block;
        Direction direction = KineticsHelper.directionBetween((BlockPos)target.m_58899_(), (BlockPos)this.m_58899_());
        if (direction != null && (block = stateTo.m_60734_()) instanceof IRotate && (iRotate = (IRotate)block).hasShaftTowards((LevelReader)this.m_58904_(), target.m_58899_(), stateTo, direction)) {
            CoaxialGearBlock.updatePropagationOfLongShaft(stateFrom, (LevelReader)this.f_58857_, this.m_58899_());
        }
        return super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
    }

    public void tick() {
        super.tick();
        if (this.isVirtual() || !this.m_58898_()) {
            return;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)CoaxialGearBlock.HAS_SHAFT)).booleanValue() && !this.m_58904_().m_5776_()) {
            Direction.Axis axis = (Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS);
            boolean longShaftExists = false;
            for (Direction.AxisDirection axisDirection : Direction.AxisDirection.values()) {
                BlockPos longShaftPos = this.m_58899_().m_121945_(Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)axis));
                BlockState longShaftState = this.m_58904_().m_8055_(longShaftPos);
                if (!PetrolsPartsBlocks.LONG_SHAFT.has(longShaftState) || longShaftState.m_61143_((Property)RotatedPillarKineticBlock.AXIS) != axis || (Boolean)longShaftState.m_61143_((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION) != (axisDirection != Direction.AxisDirection.POSITIVE)) continue;
                longShaftExists = true;
                if (this.speed == 0.0f || this.advancementBehaviour.getPlayer() == null || !this.m_58904_().m_141902_(longShaftPos, (BlockEntityType)PetrolsPartsBlockEntityTypes.LONG_SHAFT.get()).map(be -> be.getSpeed() != 0.0f && be.getSpeed() != this.speed).orElse(false).booleanValue()) break;
                this.advancementBehaviour.awardAdvancement(PetrolsPartsAdvancementTrigger.COAXIAL_GEAR);
                break;
            }
            if (!longShaftExists) {
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)RotatedPillarKineticBlock.AXIS, (Comparable)axis));
                Block.m_49950_((BlockState)this.m_58900_(), (Level)this.f_58857_, (BlockPos)this.m_58899_());
            }
        }
    }
}

