/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.recipe.ingredient;

import com.google.gson.JsonObject;
import dev.kvnmtz.createmobspawners.capabilities.entitystorage.StoredEntityData;
import dev.kvnmtz.createmobspawners.capabilities.registry.ModCapabilities;
import dev.kvnmtz.createmobspawners.item.custom.SoulCatcherItem;
import dev.kvnmtz.createmobspawners.item.registry.ModItems;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;

public class SoulCatcherIngredient
extends Ingredient {
    private final ResourceLocation requiredEntityType;

    public SoulCatcherIngredient(ResourceLocation requiredEntityType) {
        super(Stream.of(new Ingredient.ItemValue(SoulCatcherIngredient.createDisplayItem(requiredEntityType))));
        this.requiredEntityType = requiredEntityType;
    }

    private static ItemStack createDisplayItem(ResourceLocation entityType) {
        ItemStack stack = ((SoulCatcherItem)((Object)ModItems.SOUL_CATCHER.get())).m_7968_();
        CompoundTag dataTag = new CompoundTag();
        CompoundTag entityTag = new CompoundTag();
        entityTag.m_128359_("id", entityType.toString());
        dataTag.m_128365_("Entity", (Tag)entityTag);
        StoredEntityData entityData = StoredEntityData.empty();
        entityData.deserializeNBT((Tag)dataTag);
        stack.getCapability(ModCapabilities.ENTITY_STORAGE).ifPresent(storage -> storage.setStoredEntityData(entityData));
        return stack;
    }

    public boolean test(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.m_41720_() != ModItems.SOUL_CATCHER.get()) {
            return false;
        }
        Optional<StoredEntityData> entityData = SoulCatcherItem.getEntityData(stack);
        if (entityData.isEmpty()) {
            return false;
        }
        Optional<ResourceLocation> entityType = entityData.get().getEntityTypeResourceLocation();
        return entityType.isPresent() && entityType.get().equals((Object)this.requiredEntityType);
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<SoulCatcherIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @NotNull
        public SoulCatcherIngredient parse(@NotNull FriendlyByteBuf buffer) {
            return new SoulCatcherIngredient(buffer.m_130281_());
        }

        @NotNull
        public SoulCatcherIngredient parse(@NotNull JsonObject json) {
            ResourceLocation entityType = new ResourceLocation(json.get("entity_type").getAsString());
            return new SoulCatcherIngredient(entityType);
        }

        public void write(@NotNull FriendlyByteBuf buffer, @NotNull SoulCatcherIngredient ingredient) {
            buffer.m_130085_(ingredient.requiredEntityType);
        }
    }
}

