/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.recipe.custom;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SpawningRecipe
implements Recipe<RecipeWrapper> {
    protected final ResourceLocation id;
    protected final FluidIngredient fluidIngredient;
    protected final int spawnTicksAtMaxSpeed;
    protected final int additionalSpawnAttempts;
    private final List<ResourceLocation> blacklist;
    private final List<ResourceLocation> whitelist;
    @Nullable
    private final Integer particleColor;

    public SpawningRecipe(ResourceLocation id, FluidIngredient fluidIngredient, int spawnTicksAtMaxSpeed, int additionalSpawnAttempts, List<ResourceLocation> blacklist, List<ResourceLocation> whitelist, @Nullable Integer particleColor) {
        if (!blacklist.isEmpty() && !whitelist.isEmpty()) {
            throw new IllegalArgumentException("Spawning recipe cannot have both blacklist and whitelist");
        }
        this.id = id;
        this.fluidIngredient = fluidIngredient;
        this.spawnTicksAtMaxSpeed = spawnTicksAtMaxSpeed;
        this.additionalSpawnAttempts = additionalSpawnAttempts;
        this.blacklist = blacklist;
        this.whitelist = whitelist;
        this.particleColor = particleColor;
    }

    public FluidIngredient getFluidIngredient() {
        return this.fluidIngredient;
    }

    public int getSpawnTicksAtMaxSpeed() {
        return this.spawnTicksAtMaxSpeed;
    }

    public int getAdditionalSpawnAttempts() {
        return this.additionalSpawnAttempts;
    }

    public List<ResourceLocation> getBlacklist() {
        return this.blacklist;
    }

    public List<ResourceLocation> getWhitelist() {
        return this.whitelist;
    }

    @Nullable
    public Integer getParticleColor() {
        return this.particleColor;
    }

    public boolean matches(RecipeWrapper recipeWrapper, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeWrapper recipeWrapper, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<SpawningRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public SpawningRecipe fromJson(ResourceLocation id, JsonObject jsonObject) {
            JsonElement whitelistObj;
            FluidIngredient fluidIngredient = FluidIngredient.deserialize((JsonElement)jsonObject.get("input"));
            int spawnTicksAtMaxSpeed = jsonObject.get("spawn_ticks_at_max_speed").getAsInt();
            int additionalSpawnAttempts = jsonObject.get("additional_spawn_attempts").getAsInt();
            ArrayList<ResourceLocation> blacklist = new ArrayList<ResourceLocation>();
            ArrayList<ResourceLocation> whitelist = new ArrayList<ResourceLocation>();
            JsonElement blacklistObj = jsonObject.get("spawnable_entity_blacklist");
            if (blacklistObj != null) {
                blacklist.addAll(blacklistObj.getAsJsonArray().asList().stream().map(e -> new ResourceLocation(e.getAsString())).toList());
            }
            if ((whitelistObj = jsonObject.get("spawnable_entity_whitelist")) != null) {
                whitelist.addAll(whitelistObj.getAsJsonArray().asList().stream().map(e -> new ResourceLocation(e.getAsString())).toList());
            }
            Integer optParticleColor = null;
            JsonElement particleColorObj = jsonObject.get("particle_color");
            if (particleColorObj != null) {
                String particleColorHex = particleColorObj.getAsString();
                if (particleColorHex.startsWith("#")) {
                    particleColorHex = particleColorHex.substring(1);
                }
                optParticleColor = Integer.parseInt(particleColorHex, 16);
            }
            return new SpawningRecipe(id, fluidIngredient, spawnTicksAtMaxSpeed, additionalSpawnAttempts, blacklist, whitelist, optParticleColor);
        }

        @Nullable
        public SpawningRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            FluidIngredient fluidIngredient = FluidIngredient.read((FriendlyByteBuf)buffer);
            int spawnTicksAtMaxSpeed = buffer.readInt();
            int additionalSpawnTries = buffer.readInt();
            ArrayList<ResourceLocation> blacklist = new ArrayList<ResourceLocation>();
            ArrayList<ResourceLocation> whitelist = new ArrayList<ResourceLocation>();
            int blacklistLength = buffer.readInt();
            for (int i = 0; i < blacklistLength; ++i) {
                blacklist.add(buffer.m_130281_());
            }
            int whitelistLength = buffer.readInt();
            for (int i = 0; i < whitelistLength; ++i) {
                whitelist.add(buffer.m_130281_());
            }
            Optional particleColor = buffer.m_236860_(FriendlyByteBuf::readInt);
            return new SpawningRecipe(id, fluidIngredient, spawnTicksAtMaxSpeed, additionalSpawnTries, blacklist, whitelist, particleColor.orElse(null));
        }

        public void toNetwork(FriendlyByteBuf buffer, SpawningRecipe spawningRecipe) {
            spawningRecipe.fluidIngredient.write(buffer);
            buffer.writeInt(spawningRecipe.spawnTicksAtMaxSpeed);
            buffer.writeInt(spawningRecipe.additionalSpawnAttempts);
            buffer.writeInt(spawningRecipe.blacklist.size());
            for (ResourceLocation entityId : spawningRecipe.blacklist) {
                buffer.m_130085_(entityId);
            }
            buffer.writeInt(spawningRecipe.whitelist.size());
            for (ResourceLocation entityId : spawningRecipe.whitelist) {
                buffer.m_130085_(entityId);
            }
            buffer.m_236835_(Optional.ofNullable(spawningRecipe.particleColor), FriendlyByteBuf::writeInt);
        }
    }

    public static class Type
    implements RecipeType<SpawningRecipe> {
        public static final Type INSTANCE = new Type();
    }
}

