/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.ponder.scenes;

import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import dev.kvnmtz.createmobspawners.CreateMobSpawners;
import dev.kvnmtz.createmobspawners.item.custom.SoulCatcherItem;
import dev.kvnmtz.createmobspawners.item.registry.ModItems;
import dev.kvnmtz.createmobspawners.utils.ParticleUtils;
import java.util.concurrent.atomic.AtomicReference;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.foundation.ui.PonderUI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;

@Mod.EventBusSubscriber(modid="create_mob_spawners", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public abstract class SoulCatcherScenes {
    private static final Quaternionf alignedCameraOrientation = new Quaternionf().rotateYXZ((float)Math.toRadians(35.0), (float)Math.toRadians(25.0), 0.0f);
    private static Quaternionf originalCameraOrientation;

    @SubscribeEvent
    protected static void preRenderScreen(ScreenEvent.Render.Pre event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof PonderUI)) {
            return;
        }
        PonderUI ponderUi = (PonderUI)screen;
        if (!ponderUi.getActiveScene().getId().equals((Object)CreateMobSpawners.asResource("soul_catcher"))) {
            return;
        }
        EntityRenderDispatcher entityRendererDispatcher = Minecraft.m_91087_().m_91290_();
        originalCameraOrientation = entityRendererDispatcher.m_253208_();
        entityRendererDispatcher.m_252923_(alignedCameraOrientation);
    }

    @SubscribeEvent
    protected static void postRenderScreen(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof PonderUI)) {
            return;
        }
        PonderUI ponderUi = (PonderUI)screen;
        if (!ponderUi.getActiveScene().getId().equals((Object)CreateMobSpawners.asResource("soul_catcher"))) {
            return;
        }
        EntityRenderDispatcher entityRendererDispatcher = Minecraft.m_91087_().m_91290_();
        entityRendererDispatcher.m_252923_(originalCameraOrientation);
    }

    public static void soulCatcher(SceneBuilder builder, SceneBuildingUtil ignoredUtil) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("soul_catcher", "Soul Catcher");
        scene.showBasePlate();
        scene.idle(5);
        Vec3 pigPosition = new Vec3(2.5, 1.0, 2.5);
        Vec3 pigCenter = pigPosition.m_82520_(0.0, (double)0.45f, 0.0);
        AtomicReference pigReference = new AtomicReference();
        ElementLink pigEntity = scene.world().createEntity(w -> {
            Pig pig = (Pig)EntityType.f_20510_.m_20615_(w);
            if (pig == null) {
                return null;
            }
            pig.f_19854_ = pigPosition.f_82479_;
            pig.f_19855_ = pigPosition.f_82480_;
            pig.f_19856_ = pigPosition.f_82481_;
            pig.m_20343_(pig.f_19854_, pig.f_19855_, pig.f_19856_);
            pig.f_19859_ = 180.0f;
            pig.m_146922_(180.0f);
            pig.f_20886_ = 180.0f;
            pig.m_5616_(180.0f);
            pigReference.set(pig);
            return pig;
        });
        scene.overlay().showText(60).placeNearTarget().pointAt(pigCenter).text("See this innocent pig? Let's catch it.");
        scene.idleSeconds(3);
        scene.overlay().showText(80).attachKeyFrame().placeNearTarget().pointAt(pigCenter).text("In order to catch a mob's soul, it needs to be weakened (e.g. with a Splash Potion of Healing)");
        scene.idleSeconds(4);
        AtomicReference<Integer> potionColor = new AtomicReference<Integer>(0);
        ElementLink potionEntity = scene.world().createEntity(w -> {
            ThrownPotion potion = (ThrownPotion)EntityType.f_20486_.m_20615_(w);
            if (potion == null) {
                return null;
            }
            Item potionItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:splash_potion"));
            if (potionItem == null) {
                return null;
            }
            ItemStack potionItemStack = potionItem.m_7968_();
            PotionUtils.m_43549_((ItemStack)potionItemStack, (Potion)Potions.f_43593_);
            potion.m_37446_(potionItemStack);
            potionColor.set(PotionUtils.m_43575_((ItemStack)potionItemStack));
            Vec3 potionPosition = pigPosition.m_82520_(0.0, 2.0, 0.0);
            potion.f_19854_ = potionPosition.f_82479_;
            potion.f_19855_ = potionPosition.f_82480_;
            potion.f_19856_ = potionPosition.f_82481_;
            potion.m_20343_(potion.f_19854_, potion.f_19855_, potion.f_19856_);
            potion.m_6686_(0.0, 1.0, 0.0, 0.25f, 0.0f);
            return potion;
        });
        scene.idle(14);
        scene.world().modifyEntity(potionEntity, e -> {
            ThrownPotion potion = (ThrownPotion)e;
            ItemStack itemStack = potion.m_7846_();
            int color = PotionUtils.m_43575_((ItemStack)itemStack);
            RandomSource random = potion.m_9236_().f_46441_;
            Vec3 splashOrigin = potion.m_20182_();
            for (int i = 0; i < 8; ++i) {
                potion.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42736_)), splashOrigin.f_82479_, splashOrigin.f_82480_, splashOrigin.f_82481_, random.m_188583_() * 0.15, random.m_188500_() * 0.2, random.m_188583_() * 0.15);
            }
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float blue = (float)(color >> 8 & 0xFF) / 255.0f;
            float green = (float)(color & 0xFF) / 255.0f;
            for (int i = 0; i < 100; ++i) {
                double d13 = random.m_188500_() * 1.5;
                double d19 = random.m_188500_() * Math.PI * 2.0;
                double d25 = Math.cos(d19) * d13;
                double d30 = 0.01 + random.m_188500_() * 0.5;
                double d31 = Math.sin(d19) * d13;
                Particle particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123806_, splashOrigin.f_82479_ + d25 * 0.1, splashOrigin.f_82480_ + 0.3, splashOrigin.f_82481_ + d31 * 0.1, d25, d30, d31);
                if (particle != null) {
                    float randomShift = 0.75f + random.m_188501_() * 0.25f;
                    particle.m_107253_(red * randomShift, blue * randomShift, green * randomShift);
                    particle.m_107268_((float)d13);
                }
                ((PonderLevel)potion.m_9236_()).addParticle(particle);
            }
            potion.m_146870_();
        });
        scene.effects().emitParticles(Vec3.f_82478_, (level, unused1, unused2, unused3) -> {
            Pig pig = (Pig)pigReference.get();
            ParticleUtils.drawPotionEffectParticles((Level)level, pig.m_20191_(), pig.m_20182_(), (Integer)potionColor.get(), 1);
        }, 1.0f, 107);
        scene.idleSeconds(3);
        scene.overlay().showText(40).attachKeyFrame().placeNearTarget().pointAt(pigCenter).text("Now, right-click it with an empty Soul Catcher to start catching its soul");
        scene.idleSeconds(2);
        scene.overlay().showControls(pigCenter.m_82520_(0.0, 0.5, 0.0), Pointing.DOWN, 40).rightClick().withItem(((SoulCatcherItem)((Object)ModItems.EMPTY_SOUL_CATCHER.get())).m_7968_());
        scene.idle(7);
        scene.world().modifyEntity(pigEntity, pig -> {
            SoulCatcherItem.addShrinkingEntity(pig);
            ParticleUtils.drawPotionEffectLikeParticles((ParticleOptions)ParticleTypes.f_123771_, pig.m_9236_(), pig.m_20191_(), pig.m_20182_(), new Vec3(0.1, 0.1, 0.1), ParticleUtils.getParticleCountForEntity(pig), 0.75f);
        });
        scene.idle(SoulCatcherItem.getCatchingDurationInTicks(AABB.m_165882_((Vec3)Vec3.f_82478_, (double)0.9f, (double)0.9f, (double)0.9f)));
        scene.world().modifyEntity(pigEntity, pig -> {
            AABB bb = ((Pig)pigReference.get()).m_20191_();
            ParticleUtils.drawParticles((ParticleOptions)ParticleTypes.f_123789_, pig.m_9236_(), pigCenter, ParticleUtils.getParticleCountForEntity(pig), bb.m_82362_() / 3.0, bb.m_82376_() / 3.0, bb.m_82385_() / 3.0, Vec3.f_82478_);
            pig.m_146870_();
        });
        scene.idleSeconds(1);
        scene.overlay().showText(40).independent(0).placeNearTarget().text("Gotcha! The pig was caught.");
        scene.idle(10);
        scene.overlay().showText(60).attachKeyFrame().independent(24).placeNearTarget().text("If you want to release it again, just right-click the desired position with the Soul Catcher");
        scene.idleSeconds(3);
        scene.overlay().showControls(pigPosition, Pointing.DOWN, 20).rightClick().withItem(((SoulCatcherItem)((Object)ModItems.SOUL_CATCHER.get())).m_7968_());
        scene.idle(30);
        scene.world().createEntity(w -> {
            Pig pig = (Pig)EntityType.f_20510_.m_20615_(w);
            if (pig == null) {
                return null;
            }
            pig.f_19854_ = pigPosition.f_82479_;
            pig.f_19855_ = pigPosition.f_82480_;
            pig.f_19856_ = pigPosition.f_82481_;
            pig.m_20343_(pig.f_19854_, pig.f_19855_, pig.f_19856_);
            pig.f_19859_ = 180.0f;
            pig.m_146922_(180.0f);
            pig.f_20886_ = 180.0f;
            pig.m_5616_(180.0f);
            ParticleUtils.drawPotionEffectLikeParticles((ParticleOptions)ParticleTypes.f_123771_, pig.m_9236_(), pig.m_20191_(), pig.m_20182_(), new Vec3(0.1, 0.1, 0.1), ParticleUtils.getParticleCountForEntity((Entity)pig), 0.75f);
            return pig;
        });
        scene.idleSeconds(2);
        scene.markAsFinished();
    }
}

