/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.network.packet;

import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import dev.kvnmtz.createmobspawners.CreateMobSpawners;
import dev.kvnmtz.createmobspawners.block.custom.entity.MechanicalSpawnerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public class ServerboundConfigureSpawnerPacket
extends BlockEntityConfigurationPacket<MechanicalSpawnerBlockEntity> {
    private int width;
    private int height;
    private int yOffset;

    public ServerboundConfigureSpawnerPacket(BlockPos pos, int width, int height, int yOffset) {
        super(pos);
        this.width = width;
        this.height = height;
        this.yOffset = yOffset;
    }

    public ServerboundConfigureSpawnerPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    protected void readSettings(FriendlyByteBuf buffer) {
        this.width = buffer.readByte();
        this.height = buffer.readByte();
        this.yOffset = buffer.readByte();
    }

    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.writeByte(this.width);
        buffer.writeByte(this.height);
        buffer.writeByte(this.yOffset);
    }

    protected void applySettings(MechanicalSpawnerBlockEntity be) {
        if (!((Boolean)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerConfigurationAllowed.get()).booleanValue()) {
            return;
        }
        if (this.width % 2 == 0 || this.height % 2 == 0) {
            return;
        }
        if (this.width < (Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaMinWidth.get() || this.width > (Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaMaxWidth.get()) {
            return;
        }
        if (this.height < (Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaMinHeight.get() || this.height > (Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaMaxHeight.get()) {
            return;
        }
        if (this.yOffset < (Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaMinHeightOffset.get() || this.yOffset > (Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaMaxHeightOffset.get()) {
            return;
        }
        be.setSpawningAreaWidth(this.width);
        be.setSpawningAreaHeight(this.height);
        be.setSpawningAreaHeightOffset(this.yOffset);
    }
}

