/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.network.packet;

import dev.kvnmtz.createmobspawners.item.custom.SoulCatcherItem;
import dev.kvnmtz.createmobspawners.utils.ParticleUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundEntityCatchPacket {
    private final int entityId;
    private final int playerId;
    private final EntityCatchState state;

    public ClientboundEntityCatchPacket(int entityId, int playerId, EntityCatchState state) {
        this.entityId = entityId;
        this.playerId = playerId;
        this.state = state;
    }

    public ClientboundEntityCatchPacket(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt(), EntityCatchState.values()[buffer.readByte()]);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public EntityCatchState getState() {
        return this.state;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.playerId);
        buffer.writeByte(this.state.ordinal());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHandler.handle(this)));
        ctx.get().setPacketHandled(true);
    }

    public static enum EntityCatchState {
        STARTED,
        IN_PROGRESS,
        FINISHED,
        CANCELED;

    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void handle(ClientboundEntityCatchPacket packet) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.getEntityId());
            if (entity == null) {
                return;
            }
            if (packet.getState() == EntityCatchState.CANCELED) {
                SoulCatcherItem.removeShrinkingEntity(entity);
                return;
            }
            Entity player = Minecraft.m_91087_().f_91073_.m_6815_(packet.getPlayerId());
            if (player == null) {
                return;
            }
            AABB entityBoundingBox = entity.m_20191_();
            Vec3 entityCenter = entityBoundingBox.m_82399_();
            Vec3 playerCenter = player.m_20191_().m_82399_();
            Vec3 direction = entityCenter.m_82546_(playerCenter).m_82541_();
            Vec3 pointInFrontOfPlayer = playerCenter.m_82549_(direction.m_82542_((double)0.66f, (double)0.66f, (double)0.66f));
            switch (packet.getState()) {
                case STARTED: {
                    SoulCatcherItem.addShrinkingEntity(entity);
                    ParticleUtils.drawParticleLine((ParticleOptions)ParticleTypes.f_123771_, (Level)level, entityBoundingBox.m_82399_(), pointInFrontOfPlayer, 0.5, Vec3.f_82478_);
                    ParticleUtils.drawPotionEffectLikeParticles((ParticleOptions)ParticleTypes.f_123771_, (Level)level, entityBoundingBox, entity.m_20182_(), new Vec3(0.1, 0.1, 0.1), ParticleUtils.getParticleCountForEntity(entity), 0.75f);
                    break;
                }
                case IN_PROGRESS: {
                    ParticleUtils.drawParticleLine((ParticleOptions)ParticleTypes.f_123771_, (Level)level, entityBoundingBox.m_82399_(), pointInFrontOfPlayer, 0.5, Vec3.f_82478_);
                    break;
                }
                case FINISHED: {
                    ParticleUtils.drawParticles((ParticleOptions)ParticleTypes.f_123789_, (Level)level, entityCenter, ParticleUtils.getParticleCountForEntity(entity), entityBoundingBox.m_82362_() / 3.0, entityBoundingBox.m_82376_() / 3.0, entityBoundingBox.m_82385_() / 3.0, Vec3.f_82478_);
                }
            }
        }
    }
}

