/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.block.custom.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.kvnmtz.createmobspawners.block.custom.entity.MechanicalSpawnerBlockEntity;
import dev.kvnmtz.createmobspawners.item.custom.SoulCatcherItem;
import dev.kvnmtz.createmobspawners.item.registry.ModItems;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.platform.ForgeCatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class MechanicalSpawnerBlockEntityRenderer
extends KineticBlockEntityRenderer<MechanicalSpawnerBlockEntity> {
    public MechanicalSpawnerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected BlockState getRenderedBlockState(MechanicalSpawnerBlockEntity be) {
        return KineticBlockEntityRenderer.shaft((Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }

    protected void renderSafe(MechanicalSpawnerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (be.m_58904_() == null) {
            return;
        }
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        KineticBlockEntityRenderer.renderRotatingKineticBlock((KineticBlockEntity)be, (BlockState)this.getRenderedBlockState(be), (PoseStack)ms, (VertexConsumer)vb, (int)light);
        this.renderSoulCatcher(be, ms, buffer, light);
        this.renderContainedFluid(be, partialTicks, ms, buffer, light);
    }

    private void renderSoulCatcher(MechanicalSpawnerBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light) {
        if (!be.hasStoredEntity()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack itemStack = ((SoulCatcherItem)((Object)ModItems.SOUL_CATCHER.get())).m_7968_();
        ms.m_85836_();
        ms.m_252880_(0.5f, 0.5f, 0.5f);
        ms.m_85841_(0.8f, 0.8f, 0.8f);
        ms.m_252781_(Axis.f_252436_.m_252977_(MechanicalSpawnerBlockEntityRenderer.getAngleForBe((KineticBlockEntity)be, (BlockPos)be.m_58899_(), (Direction.Axis)Direction.Axis.Y) * 180.0f / (float)Math.PI));
        itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIXED, light, OverlayTexture.f_118083_, ms, buffer, be.m_58904_(), 1);
        ms.m_85849_();
    }

    private void renderContainedFluid(MechanicalSpawnerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        LerpedFloat fluidLevel = be.getTank().getPrimaryTank().getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 0.0703125f;
        float tankHullWidth = 0.109375f;
        float minPuddleHeight = 0.0625f;
        float height = 1.0f;
        float width = 1.0f;
        float totalHeight = height - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.m_14036_((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        FluidStack fluidStack = be.getFluidStack();
        if (!fluidStack.isEmpty()) {
            boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
            float xMax = tankHullWidth + width - 2.0f * tankHullWidth;
            float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
            float yMax = yMin + clampedLevel;
            if (top) {
                yMin += totalHeight - clampedLevel;
                yMax += totalHeight - clampedLevel;
            }
            float zMax = tankHullWidth + width - 2.0f * tankHullWidth;
            ms.m_85836_();
            ms.m_252880_(0.0f, clampedLevel - totalHeight, 0.0f);
            ForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, tankHullWidth, yMin, tankHullWidth, xMax, yMax, zMax, buffer, ms, light, false, true);
            ms.m_85849_();
        }
    }
}

