/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.block.custom.entity;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import dev.kvnmtz.createmobspawners.CreateMobSpawners;
import dev.kvnmtz.createmobspawners.block.custom.MechanicalSpawnerBlock;
import dev.kvnmtz.createmobspawners.capabilities.entitystorage.IEntityStorage;
import dev.kvnmtz.createmobspawners.capabilities.entitystorage.StoredEntityData;
import dev.kvnmtz.createmobspawners.capabilities.registry.ModCapabilities;
import dev.kvnmtz.createmobspawners.item.custom.SoulCatcherItem;
import dev.kvnmtz.createmobspawners.item.registry.ModItems;
import dev.kvnmtz.createmobspawners.network.PacketHandler;
import dev.kvnmtz.createmobspawners.network.packet.ClientboundSpawnerEventPacket;
import dev.kvnmtz.createmobspawners.recipe.custom.SpawningRecipe;
import dev.kvnmtz.createmobspawners.recipe.registry.ModRecipes;
import dev.kvnmtz.createmobspawners.utils.DropUtils;
import dev.kvnmtz.createmobspawners.utils.ParticleUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MechanicalSpawnerBlockEntity
extends KineticBlockEntity
implements IEntityStorage {
    private StoredEntityData storedEntityData = StoredEntityData.empty();
    private float stressImpact = 8.0f;
    private int spawningAreaWidth;
    private int spawningAreaHeight;
    private int spawningAreaHeightOffset;
    private SmartFluidTankBehaviour tank;
    private float spawnProgress = 0.0f;
    private int delayTicks = -1;
    private DelayReason delayReason;
    private int spawnAreaHighlightingTicks = 0;
    private int lingerWidth;
    private int lingerHeight;
    private int lingerHeightOffset;
    private final Object spawnAreaOutlineSlot = new Object();

    public MechanicalSpawnerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.spawningAreaWidth = (Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaDefaultWidth.get();
        this.spawningAreaHeight = (Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaDefaultHeight.get();
        this.spawningAreaHeightOffset = (Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaDefaultHeightOffset.get();
    }

    @Override
    public StoredEntityData getStoredEntityData() {
        return this.storedEntityData;
    }

    @Override
    public void setStoredEntityData(StoredEntityData entityData) {
        this.storedEntityData = entityData;
        this.onStoredEntityDataChanged();
    }

    private void onStoredEntityDataChanged() {
        this.stressImpact = this.calculateStressImpactForContainedSoulCatcher();
        this.spawnProgress = 0.0f;
    }

    private float calculateStressImpactForContainedSoulCatcher() {
        if (this.f_58857_ == null) {
            return 0.0f;
        }
        Optional<EntityType<?>> optEntityType = this.storedEntityData.getEntityType();
        if (optEntityType.isEmpty()) {
            return 0.0f;
        }
        EntityType<?> entityType = optEntityType.get();
        LivingEntity entity = (LivingEntity)entityType.m_20615_(this.f_58857_);
        if (entity == null) {
            return 0.0f;
        }
        float health = entity.m_21233_();
        entity.m_146870_();
        float rawImpact = (float)(9.652871E-4 * Math.pow(health, 3.0) - 0.0548339331 * Math.pow(health, 2.0) + 1.5872319688 * (double)health + 2.4666366772);
        return Mth.m_14036_((float)rawImpact, (float)4.0f, (float)((Double)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerMaxStressImpact.get()).floatValue());
    }

    public int getSpawningAreaWidth() {
        return this.spawningAreaWidth;
    }

    public void setSpawningAreaWidth(int spawningAreaWidth) {
        this.spawningAreaWidth = spawningAreaWidth;
    }

    public int getSpawningAreaHeight() {
        return this.spawningAreaHeight;
    }

    public void setSpawningAreaHeight(int spawningAreaHeight) {
        this.spawningAreaHeight = spawningAreaHeight;
    }

    public int getSpawningAreaHeightOffset() {
        return this.spawningAreaHeightOffset;
    }

    public void setSpawningAreaHeightOffset(int spawningAreaHeightOffset) {
        this.spawningAreaHeightOffset = spawningAreaHeightOffset;
    }

    public SmartFluidTankBehaviour getTank() {
        return this.tank;
    }

    public FluidStack getFluidStack() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("EntityStorage", this.storedEntityData.serializeNBT());
        compound.m_128405_("SpawnAreaWidth", this.spawningAreaWidth);
        compound.m_128405_("SpawnAreaHeight", this.spawningAreaHeight);
        compound.m_128405_("SpawnAreaHeightOffset", this.spawningAreaHeightOffset);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.storedEntityData.deserializeNBT((Tag)compound.m_128469_("EntityStorage"));
        this.onStoredEntityDataChanged();
        this.spawningAreaWidth = compound.m_128451_("SpawnAreaWidth");
        if (this.spawningAreaWidth == 0) {
            this.spawningAreaWidth = (Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaDefaultWidth.get();
        }
        this.spawningAreaHeight = compound.m_128451_("SpawnAreaHeight");
        if (this.spawningAreaHeight == 0) {
            this.spawningAreaHeight = (Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaDefaultHeight.get();
        }
        this.spawningAreaHeightOffset = compound.m_128441_("SpawnAreaHeightOffset") ? compound.m_128451_("SpawnAreaHeightOffset") : ((Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaDefaultHeightOffset.get()).intValue();
        super.read(compound, clientPacket);
    }

    private Optional<SpawningRecipe> getCurrentRecipe() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        List potentialRecipes = this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipes.SPAWNING.get());
        for (SpawningRecipe recipe : potentialRecipes) {
            if (!recipe.getFluidIngredient().getMatchingFluidStacks().contains(this.getFluidStack())) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    public Optional<Integer> getParticleColor() {
        int color = PotionUtils.m_43559_((Potion)Potions.f_43587_);
        if (this.getCurrentRecipe().isEmpty()) {
            return Optional.empty();
        }
        SpawningRecipe recipe = this.getCurrentRecipe().get();
        if (recipe.getParticleColor() != null) {
            color = recipe.getParticleColor();
        } else {
            FluidStack fluidStack = (FluidStack)recipe.getFluidIngredient().matchingFluidStacks.get(0);
            if (fluidStack.hasTag()) {
                color = PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)fluidStack.getTag()));
            }
        }
        return Optional.of(color);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        this.tank.getPrimaryHandler().setValidator(fluidStack -> {
            if (this.f_58857_ == null) {
                return false;
            }
            List potentialRecipes = this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipes.SPAWNING.get());
            for (SpawningRecipe recipe : potentialRecipes) {
                if (!recipe.getFluidIngredient().getMatchingFluidStacks().contains(fluidStack)) continue;
                return true;
            }
            return false;
        });
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == ((Direction)this.m_58900_().m_61143_((Property)MechanicalSpawnerBlock.FACING)).m_122424_()) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public void ejectSoulCatcher() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.storedEntityData.isEmpty()) {
            return;
        }
        ItemStack itemStack = ((SoulCatcherItem)((Object)ModItems.SOUL_CATCHER.get())).m_7968_();
        itemStack.getCapability(ModCapabilities.ENTITY_STORAGE).ifPresent(entityStorage -> {
            entityStorage.setStoredEntityData(this.storedEntityData);
            Set<ItemEntity> droppedItems = DropUtils.dropItemStack(this.f_58857_, this.f_58858_.m_123341_(), this.f_58858_.m_123342_() + 1, this.f_58858_.m_123343_(), itemStack);
            droppedItems.stream().findFirst().ifPresent(itemEntity -> itemEntity.m_146915_(true));
            this.setStoredEntityData(StoredEntityData.empty());
        });
    }

    public int getSpawnProgressPercentage() {
        return Math.min(Math.round(this.spawnProgress * 100.0f), 100);
    }

    public static float getProgressForTick(float speed, int ticksAtMaxSpeed) {
        return (float)(0.0625 * Math.pow(1.0108892861, Math.abs(speed))) / (float)ticksAtMaxSpeed;
    }

    private void addProgressForTick() {
        if (this.spawnProgress >= 1.0f) {
            return;
        }
        Optional<SpawningRecipe> optRecipe = this.getCurrentRecipe();
        if (optRecipe.isEmpty()) {
            return;
        }
        SpawningRecipe recipe = optRecipe.get();
        this.spawnProgress += MechanicalSpawnerBlockEntity.getProgressForTick(this.speed, recipe.getSpawnTicksAtMaxSpeed());
    }

    private void delay(int ticks, DelayReason reason) {
        this.delayTicks = ticks;
        this.delayReason = reason;
    }

    public boolean isDelayed() {
        return this.delayTicks >= 0;
    }

    public String getDelayReasonTranslationKey() {
        return "create_mob_spawners.waila.spawner_delay_reason." + this.delayReason.name().toLowerCase();
    }

    private void useFluid() {
        Optional<SpawningRecipe> optRecipe = this.getCurrentRecipe();
        if (optRecipe.isEmpty()) {
            return;
        }
        SpawningRecipe recipe = optRecipe.get();
        FluidStack fluid = this.tank.getPrimaryHandler().getFluid();
        fluid.setAmount(fluid.getAmount() - recipe.getFluidIngredient().getRequiredAmount());
    }

    private EntitySpawnResult spawnEntity() {
        double z;
        double y;
        if (this.f_58857_ == null) {
            return new EntitySpawnResult.Delay(DelayReason.UNKNOWN);
        }
        ServerLevel level = (ServerLevel)this.f_58857_;
        Optional<EntityType<?>> optEntityType = this.storedEntityData.getEntityType();
        if (optEntityType.isEmpty()) {
            return new EntitySpawnResult.Delay(DelayReason.INVALID_ENTITY);
        }
        EntityType<?> entityType = optEntityType.get();
        BlockPos blockPos = this.m_58899_();
        Entity entity = entityType.m_20615_((Level)level);
        if (entity == null) {
            return new EntitySpawnResult.Delay(DelayReason.ENTITY_CREATION_ERROR);
        }
        int nearbyEntities = level.m_45976_(entity.getClass(), new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)(this.m_58899_().m_123341_() + 1), (double)(this.m_58899_().m_123342_() + 1), (double)(this.m_58899_().m_123343_() + 1)).m_82400_((double)Math.max(this.spawningAreaWidth, this.spawningAreaHeight) / 2.0).m_82383_(new Vec3(0.0, (double)this.spawningAreaHeightOffset, 0.0))).size();
        if (nearbyEntities >= (Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerMaxNearbyEntities.get()) {
            return new EntitySpawnResult.Delay(DelayReason.TOO_MANY_ENTITIES);
        }
        RandomSource random = level.m_213780_();
        double x = (double)blockPos.m_123341_() + (random.m_188500_() - random.m_188500_()) * (double)(this.spawningAreaWidth - 1) / 2.0 + 0.5;
        if (!level.m_45772_(entityType.m_20585_(x, y = (double)blockPos.m_123342_() + (random.m_188500_() - random.m_188500_()) * (double)(this.spawningAreaHeight - 1) / 2.0 + (double)this.spawningAreaHeightOffset + 0.5, z = (double)blockPos.m_123343_() + (random.m_188500_() - random.m_188500_()) * (double)(this.spawningAreaWidth - 1) / 2.0 + 0.5))) {
            return new EntitySpawnResult.Delay(DelayReason.SEARCHING_POSITION);
        }
        float yaw = Mth.m_14177_((float)(random.m_188501_() * 360.0f));
        entity.m_7678_(x, y, z, yaw, 0.0f);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!mob.m_6914_((LevelReader)level)) {
                return new EntitySpawnResult.Delay(DelayReason.SEARCHING_POSITION);
            }
            mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(mob.m_20183_()), MobSpawnType.SPAWNER, null, null);
        }
        level.m_7967_(entity);
        level.m_142346_(entity, GameEvent.f_157810_, BlockPos.m_274561_((double)x, (double)y, (double)z));
        return new EntitySpawnResult.Success(entity);
    }

    private void trySpawnEntity() {
        if (this.f_58857_ == null) {
            return;
        }
        Optional<SpawningRecipe> optRecipe = this.getCurrentRecipe();
        if (optRecipe.isEmpty()) {
            return;
        }
        SpawningRecipe recipe = optRecipe.get();
        int additionalSpawnAttempts = recipe.getAdditionalSpawnAttempts();
        EntitySpawnResult result = this.spawnEntity();
        if (result instanceof EntitySpawnResult.Success) {
            EntitySpawnResult.Success successfulResult = (EntitySpawnResult.Success)result;
            this.useFluid();
            Vec3 center = this.m_58899_().m_252807_();
            PacketHandler.sendToNearbyPlayers(new ClientboundSpawnerEventPacket(this.m_58899_(), successfulResult.getEntity().m_19879_()), center, 16.0, (ResourceKey<Level>)this.f_58857_.m_46472_());
            this.spawnProgress = 0.0f;
            for (int i = 0; i < additionalSpawnAttempts; ++i) {
                EntitySpawnResult subsequentResult = this.spawnEntity();
                if (!(subsequentResult instanceof EntitySpawnResult.Success)) continue;
                EntitySpawnResult.Success subsequentSuccessfulResult = (EntitySpawnResult.Success)subsequentResult;
                PacketHandler.sendToNearbyPlayers(new ClientboundSpawnerEventPacket(this.m_58899_(), subsequentSuccessfulResult.getEntity().m_19879_()), center, 16.0, (ResourceKey<Level>)this.f_58857_.m_46472_());
            }
        } else if (result instanceof EntitySpawnResult.Delay) {
            EntitySpawnResult.Delay delayResult = (EntitySpawnResult.Delay)result;
            this.delay(delayResult.getReason().getDelayTicks(), delayResult.getReason());
        }
    }

    private Optional<StallingReason> getStallingReason() {
        boolean isEntityWhitelistedByRecipe;
        boolean doesRecipeHaveWhitelist;
        if (this.speed == 0.0f) {
            return Optional.of(StallingReason.NO_ROTATIONAL_FORCE);
        }
        if (Mth.m_14154_((float)this.speed) < ((Double)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerMinRpm.get()).floatValue()) {
            return Optional.of(StallingReason.ROTATION_SPEED_TOO_LOW);
        }
        if (this.storedEntityData.isEmpty()) {
            return Optional.of(StallingReason.NO_SOUL);
        }
        Optional<SpawningRecipe> optRecipe = this.getCurrentRecipe();
        if (optRecipe.isEmpty()) {
            return Optional.of(StallingReason.NOT_ENOUGH_FLUID);
        }
        SpawningRecipe recipe = optRecipe.get();
        FluidStack fluid = this.tank.getPrimaryHandler().getFluid();
        if (fluid.getAmount() < recipe.getFluidIngredient().getRequiredAmount()) {
            return Optional.of(StallingReason.NOT_ENOUGH_FLUID);
        }
        ResourceLocation storedEntityId = this.storedEntityData.getEntityTypeResourceLocation().get();
        boolean isEntityBlacklistedByRecipe = recipe.getBlacklist().contains(storedEntityId);
        if (isEntityBlacklistedByRecipe) {
            return Optional.of(StallingReason.RECIPE_CANT_SPAWN_ENTITY);
        }
        boolean bl = doesRecipeHaveWhitelist = !recipe.getWhitelist().isEmpty();
        if (doesRecipeHaveWhitelist && !(isEntityWhitelistedByRecipe = recipe.getWhitelist().contains(storedEntityId))) {
            return Optional.of(StallingReason.RECIPE_CANT_SPAWN_ENTITY);
        }
        return Optional.empty();
    }

    public Optional<String> getStallingReasonTranslationKey() {
        Optional<StallingReason> reason = this.getStallingReason();
        return reason.map(stallingReason -> stallingReason.name().toLowerCase());
    }

    public void lingerSpawnAreaHighlighting(int width, int height, int yOffset) {
        this.spawnAreaHighlightingTicks = 100;
        this.lingerWidth = width;
        this.lingerHeight = height;
        this.lingerHeightOffset = yOffset;
    }

    public void stopLingerSpawnAreaHighlighting() {
        this.spawnAreaHighlightingTicks = 0;
    }

    public void highlightSpawningArea(int width, int height, int yOffset) {
        AABB spawningArea = AABB.m_165882_((Vec3)this.m_58899_().m_252807_().m_82520_(0.0, (double)yOffset, 0.0), (double)width, (double)height, (double)width);
        Outliner.getInstance().chaseAABB(this.spawnAreaOutlineSlot, spawningArea).colored(10181046).lineWidth(0.0625f);
    }

    private void highlightSpawningArea() {
        this.highlightSpawningArea(this.lingerWidth, this.lingerHeight, this.lingerHeightOffset);
    }

    public void tick() {
        boolean unableToProgress;
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_ && this.spawnAreaHighlightingTicks > 0) {
            this.highlightSpawningArea();
            --this.spawnAreaHighlightingTicks;
        }
        if (unableToProgress = this.getStallingReason().isPresent()) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            Optional<Integer> optColor = this.getParticleColor();
            optColor.ifPresent(color -> ParticleUtils.drawPotionEffectParticles(this.f_58857_, this.getRenderBoundingBox(), this.m_58899_().m_252807_().m_82492_(0.0, 0.5, 0.0), color, 1));
            return;
        }
        if (this.isVirtual()) {
            return;
        }
        if (this.delayTicks != -1) {
            --this.delayTicks;
            if (this.delayTicks == 0) {
                this.delayTicks = -1;
                this.trySpawnEntity();
            }
        } else {
            this.addProgressForTick();
            if (this.spawnProgress >= 1.0f) {
                this.trySpawnEntity();
            }
        }
    }

    public float calculateStressApplied() {
        this.lastStressApplied = this.stressImpact;
        return this.stressImpact;
    }

    private static enum DelayReason {
        UNKNOWN(20),
        INVALID_ENTITY(20),
        SEARCHING_POSITION(5),
        ENTITY_CREATION_ERROR(20),
        TOO_MANY_ENTITIES(10);

        private final int delayTicks;

        private DelayReason(int delayTicks) {
            this.delayTicks = delayTicks;
        }

        public int getDelayTicks() {
            return this.delayTicks;
        }
    }

    private static abstract class EntitySpawnResult {
        private EntitySpawnResult() {
        }

        private static class Delay
        extends EntitySpawnResult {
            private final DelayReason reason;

            private Delay(DelayReason reason) {
                this.reason = reason;
            }

            public DelayReason getReason() {
                return this.reason;
            }
        }

        private static class Success
        extends EntitySpawnResult {
            private final Entity entity;

            private Success(Entity entity) {
                this.entity = entity;
            }

            public Entity getEntity() {
                return this.entity;
            }
        }
    }

    private static enum StallingReason {
        NO_SOUL,
        NOT_ENOUGH_FLUID,
        NO_ROTATIONAL_FORCE,
        ROTATION_SPEED_TOO_LOW,
        RECIPE_CANT_SPAWN_ENTITY;

    }
}

