/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class CreateMobSpawnersServerConfig {
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> soulCatcherEntityBlacklist;
    public final ForgeConfigSpec.DoubleValue soulCatcherMaxDistance;
    public final ForgeConfigSpec.DoubleValue soulCatcherMaxHealthPercentage;
    public final ForgeConfigSpec.BooleanValue soulCatcherAllowBosses;
    public final ForgeConfigSpec.DoubleValue soulCatcherBossMaxHealthPercentage;
    public final ForgeConfigSpec.BooleanValue soulCatcherRequireWeakness;
    public final ForgeConfigSpec.DoubleValue mechanicalSpawnerMaxStressImpact;
    public final ForgeConfigSpec.DoubleValue mechanicalSpawnerMinRpm;
    public final ForgeConfigSpec.IntValue mechanicalSpawnerMaxNearbyEntities;
    public final ForgeConfigSpec.BooleanValue mechanicalSpawnerConfigurationAllowed;
    public final ForgeConfigSpec.IntValue mechanicalSpawnerAreaMinWidth;
    public final ForgeConfigSpec.IntValue mechanicalSpawnerAreaMaxWidth;
    public final ForgeConfigSpec.IntValue mechanicalSpawnerAreaDefaultWidth;
    public final ForgeConfigSpec.IntValue mechanicalSpawnerAreaMinHeight;
    public final ForgeConfigSpec.IntValue mechanicalSpawnerAreaMaxHeight;
    public final ForgeConfigSpec.IntValue mechanicalSpawnerAreaDefaultHeight;
    public final ForgeConfigSpec.IntValue mechanicalSpawnerAreaMinHeightOffset;
    public final ForgeConfigSpec.IntValue mechanicalSpawnerAreaMaxHeightOffset;
    public final ForgeConfigSpec.IntValue mechanicalSpawnerAreaDefaultHeightOffset;

    public CreateMobSpawnersServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("soul_catcher");
        this.soulCatcherEntityBlacklist = builder.comment("Entity ids that should not be capturable").defineListAllowEmpty("entity_blacklist", List.of("minecraft:iron_golem", "minecraft:snow_golem", "minecraft:warden"), CreateMobSpawnersServerConfig::validateEntityId);
        this.soulCatcherMaxDistance = builder.comment("Maximum distance at which entities can be captured").defineInRange("max_distance", 15.0, 5.0, 50.0);
        this.soulCatcherMaxHealthPercentage = builder.comment(new String[]{"Entity health needs to be at or below this percentage to be able to be caught", "1.0 = 100% -> Entities can be caught at full health", "0.0 = Entities can only be caught at half a heart"}).defineInRange("max_health_percentage", 1.0, 0.0, 1.0);
        this.soulCatcherAllowBosses = builder.comment("Allow bosses to be captured").define("allow_bosses", false);
        this.soulCatcherBossMaxHealthPercentage = builder.comment(new String[]{"(This option is only relevant if bosses are allowed to be captured, they cannot be weakened so the remaining health needs to be checked)", "Boss entity health needs to be at or below this percentage to be able to be caught", "1.0 = 100% -> Entities can be caught at full health", "0.0 = Entities can only be caught at half a heart"}).defineInRange("max_boss_health_percentage", 0.05, 0.0, 1.0);
        this.soulCatcherRequireWeakness = builder.comment("Require weakening a mob by applying Weakness before it's capturable").define("require_weakness", true);
        builder.pop();
        builder.push("mechanical_spawner");
        this.mechanicalSpawnerMaxStressImpact = builder.comment("Maximum stress impact (impact scales with entity health)").defineInRange("max_stress_impact", 80.0, 1.0, Double.MAX_VALUE);
        this.mechanicalSpawnerMinRpm = builder.comment("Minimum RPM required to progress").defineInRange("min_rpm", 128.0, 1.0, Double.MAX_VALUE);
        this.mechanicalSpawnerMaxNearbyEntities = builder.comment(new String[]{"Maximum number of nearby spawned entities", "If exceeded, the spawner will stall"}).defineInRange("max_nearby_entities", 6, 1, Integer.MAX_VALUE);
        this.mechanicalSpawnerConfigurationAllowed = builder.comment(new String[]{"Whether the configuration of the spawning area by players is allowed or not", "true = allowed"}).define("player_configuration_allowed", true);
        this.mechanicalSpawnerAreaMinWidth = builder.comment("Minimum square width of the spawning area").defineInRange("spawn_area_min_width", 3, 3, Integer.MAX_VALUE);
        this.mechanicalSpawnerAreaMaxWidth = builder.comment("Maximum square width of the spawning area").defineInRange("spawn_area_max_width", 11, 3, Integer.MAX_VALUE);
        this.mechanicalSpawnerAreaDefaultWidth = builder.comment("Default square width of the spawning area").defineInRange("spawn_area_default_width", 9, 3, Integer.MAX_VALUE);
        this.mechanicalSpawnerAreaMinHeight = builder.comment("Minimum height of the spawning area").defineInRange("spawn_area_min_height", 1, 1, Integer.MAX_VALUE);
        this.mechanicalSpawnerAreaMaxHeight = builder.comment("Maximum height of the spawning area").defineInRange("spawn_area_max_height", 7, 1, Integer.MAX_VALUE);
        this.mechanicalSpawnerAreaDefaultHeight = builder.comment("Default height of the spawning area").defineInRange("spawn_area_default_height", 3, 1, Integer.MAX_VALUE);
        this.mechanicalSpawnerAreaMinHeightOffset = builder.comment("Minimum height offset of the spawning area").defineInRange("spawn_area_min_height_offset", -4, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.mechanicalSpawnerAreaMaxHeightOffset = builder.comment("Maximum height offset of the spawning area").defineInRange("spawn_area_max_height_offset", 4, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.mechanicalSpawnerAreaDefaultHeightOffset = builder.comment("Default height offset of the spawning area").defineInRange("spawn_area_default_height_offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        builder.pop();
    }

    private static boolean validateEntityId(Object obj) {
        String entityId;
        return obj instanceof String && ForgeRegistries.ENTITY_TYPES.containsKey(new ResourceLocation(entityId = (String)obj));
    }
}

