/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.builtin.AtmosphericNoiseParameters;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.common.Tags;

public class OceanFloorRaiserFeature
extends Feature<NoneFeatureConfiguration> {
    public OceanFloorRaiserFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos origin = context.m_159777_();
        int originX = origin.m_123341_();
        int originZ = origin.m_123343_();
        int radius = 23;
        int minX = originX - radius;
        int minZ = originZ - radius;
        int maxX = originX + radius;
        int maxZ = originZ + radius;
        float radiusSquared = radius * radius;
        NormalNoise.NoiseParameters noise = (NormalNoise.NoiseParameters)context.m_159774_().m_9598_().m_175515_(Registries.f_256865_).m_6246_(AtmosphericNoiseParameters.FLOOR_RAISE_RADIUS_OFFSET);
        if (noise == null) {
            return false;
        }
        NormalNoise radiusOffsetNoise = NormalNoise.m_230511_((RandomSource)new XoroshiroRandomSource(context.m_225041_().m_188505_()), (NormalNoise.NoiseParameters)noise);
        WorldGenLevel level = context.m_159774_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int heightRaise = 9;
        int boostedHeightRaise = heightRaise + 3;
        int raiseDecrease = boostedHeightRaise - 1;
        ArrayList<Raise> raises = new ArrayList<Raise>(Mth.m_144944_((int)(radius * 2)));
        ArrayList<DampeningPoint> dampeningPoints = new ArrayList<DampeningPoint>();
        for (int x = minX; x <= maxX; ++x) {
            int xDistanceSqr = Mth.m_144944_((int)(originX - x));
            for (int z = minZ; z <= maxZ; ++z) {
                int distanceSqr = xDistanceSqr + Mth.m_144944_((int)(originZ - z));
                if ((float)distanceSqr > radiusSquared && (double)distanceSqr > (double)radiusSquared + (double)(radiusSquared * 0.5f) * radiusOffsetNoise.m_75380_((double)x, 0.0, (double)z)) continue;
                int y = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, x, z) - 1;
                if (y < 45) {
                    dampeningPoints.add(new DampeningPoint(x, z));
                    continue;
                }
                mutable.m_122178_(x, y, z);
                BlockState state = level.m_8055_((BlockPos)mutable);
                if (state.m_60713_(Blocks.f_50079_)) {
                    state = Blocks.f_49994_.m_49966_();
                }
                if (OceanFloorRaiserFeature.canReplace(state)) {
                    raises.add(new Raise(state, mutable.m_7949_(), (float)distanceSqr / radiusSquared));
                    continue;
                }
                dampeningPoints.add(new DampeningPoint(x, z));
            }
        }
        double dampeningPower = 1.0 / (double)raiseDecrease;
        for (DampeningPoint dampeningPoint : dampeningPoints) {
            int pointX = dampeningPoint.x;
            int pointZ = dampeningPoint.z;
            for (Raise raise : raises) {
                BlockPos pos = raise.pos;
                raise.dampeningFactor += 1.0 / (double)(Mth.m_144944_((int)(pos.m_123341_() - pointX)) + Mth.m_144944_((int)(pos.m_123343_() - pointZ))) * dampeningPower;
            }
        }
        block4: for (Raise raise : raises) {
            BlockPos pos;
            int totalY;
            int increase = boostedHeightRaise - (int)(raise.dampeningFactor * (double)raiseDecrease);
            if (increase > heightRaise) {
                increase = heightRaise;
            }
            if ((totalY = (pos = raise.pos).m_123342_() + increase) > 60) {
                increase -= totalY - 60;
            }
            mutable.m_122190_((Vec3i)pos);
            BlockState raiseState = raise.state;
            for (int i = 0; i < increase; ++i) {
                mutable.m_142448_(mutable.m_123342_() + 1);
                BlockState state = level.m_8055_((BlockPos)mutable);
                if (!OceanFloorRaiserFeature.canReplace(state) && !state.m_60713_(Blocks.f_50079_) && !state.m_60819_().m_205070_(FluidTags.f_13131_)) continue block4;
                level.m_7731_((BlockPos)mutable, raiseState, 2);
            }
        }
        return raises.size() > 0;
    }

    private static boolean canReplace(BlockState state) {
        return state.m_204336_(Tags.Blocks.GRAVEL) || state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_13029_) || state.m_60713_(Blocks.f_50129_) || state.m_204336_(BlockTags.f_13061_);
    }

    private record DampeningPoint(int x, int z) {
    }

    private static final class Raise {
        private final BlockState state;
        private final BlockPos pos;
        private double dampeningFactor;

        private Raise(BlockState state, BlockPos pos, double dampeningFactor) {
            this.state = state;
            this.pos = pos;
            this.dampeningFactor = dampeningFactor;
        }
    }
}

