/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.client.model;

import com.teamabnormals.atmospheric.common.entity.Cochineal;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CochinealModel<T extends Cochineal>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftMiddleLeg;
    private final ModelPart rightMiddleLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;

    public CochinealModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftMiddleLeg = root.m_171324_("left_middle_leg");
        this.rightMiddleLeg = root.m_171324_("right_middle_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partDefinition = meshdefinition.m_171576_();
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -6.5f, -10.0f, 12.0f, 9.0f, 20.0f, deformation), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)-1.0f));
        CubeListBuilder leftLeg = CubeListBuilder.m_171558_().m_171514_(-2, 29).m_171481_(0.0f, 0.0f, -1.0f, 20.0f, 0.0f, 2.0f).m_171514_(0, 29).m_171481_(0.0f, -1.0f, 0.0f, 20.0f, 2.0f, 0.0f);
        CubeListBuilder rightLeg = CubeListBuilder.m_171558_().m_171514_(-2, 29).m_171480_().m_171481_(-20.0f, 0.0f, -1.0f, 20.0f, 0.0f, 2.0f).m_171514_(0, 29).m_171480_().m_171481_(-20.0f, -1.0f, 0.0f, 20.0f, 2.0f, 0.0f);
        partDefinition.m_171599_("left_front_leg", leftLeg, PartPose.m_171419_((float)6.0f, (float)15.0f, (float)-5.0f));
        partDefinition.m_171599_("right_front_leg", rightLeg, PartPose.m_171419_((float)-6.0f, (float)15.0f, (float)-5.0f));
        partDefinition.m_171599_("left_middle_leg", leftLeg, PartPose.m_171419_((float)6.0f, (float)15.0f, (float)1.0f));
        partDefinition.m_171599_("right_middle_leg", rightLeg, PartPose.m_171419_((float)-6.0f, (float)15.0f, (float)1.0f));
        partDefinition.m_171599_("left_hind_leg", leftLeg, PartPose.m_171419_((float)6.0f, (float)15.0f, (float)7.0f));
        partDefinition.m_171599_("right_hind_leg", rightLeg, PartPose.m_171419_((float)-6.0f, (float)15.0f, (float)7.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T cochineal, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean sucklingcactus = ((Cochineal)((Object)cochineal)).isAttachedToCactus();
        this.rightHindLeg.f_104207_ = !sucklingcactus;
        this.leftHindLeg.f_104207_ = !sucklingcactus;
        this.rightMiddleLeg.f_104207_ = !sucklingcactus;
        this.leftMiddleLeg.f_104207_ = !sucklingcactus;
        this.rightFrontLeg.f_104207_ = !sucklingcactus;
        boolean bl = this.leftFrontLeg.f_104207_ = !sucklingcactus;
        if (sucklingcactus) {
            this.body.f_104201_ = 14.0f;
            this.body.f_104202_ = -4.0f;
            this.body.f_104203_ = -1.5707964f;
        } else {
            float partialtick = ageInTicks - (float)((Cochineal)((Object)cochineal)).f_19797_;
            float jumpamount = ((Cochineal)((Object)cochineal)).getJumpAmount(partialtick);
            float noanimamount = 1.0f - jumpamount * 1.75f;
            this.body.f_104201_ = 13.5f;
            this.body.f_104202_ = -1.0f;
            this.body.f_104203_ = 0.0f;
            this.rightHindLeg.f_104205_ = -(0.58119464f + jumpamount);
            this.leftHindLeg.f_104205_ = 0.58119464f + jumpamount;
            this.rightMiddleLeg.f_104205_ = -(0.5235988f + jumpamount);
            this.leftMiddleLeg.f_104205_ = 0.5235988f + jumpamount;
            this.rightFrontLeg.f_104205_ = -(0.58119464f + jumpamount);
            this.leftFrontLeg.f_104205_ = 0.58119464f + jumpamount;
            this.rightHindLeg.f_104204_ = 0.5235988f;
            this.leftHindLeg.f_104204_ = -0.5235988f;
            this.rightMiddleLeg.f_104204_ = 0.0f;
            this.leftMiddleLeg.f_104204_ = 0.0f;
            this.rightFrontLeg.f_104204_ = -0.5235988f;
            this.leftFrontLeg.f_104204_ = 0.5235988f;
            float yHind = -(Mth.m_14089_((float)(limbSwing * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * limbSwingAmount * noanimamount;
            float yMid = -(Mth.m_14089_((float)(limbSwing * 0.6662f * 2.0f)) * 0.4f) * limbSwingAmount * noanimamount;
            float yFront = -(Mth.m_14089_((float)(limbSwing * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * limbSwingAmount * noanimamount;
            float zHind = Math.abs(Mth.m_14031_((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.4f) * limbSwingAmount * noanimamount;
            float zMid = Math.abs(Mth.m_14031_((float)(limbSwing * 0.6662f)) * 0.4f) * limbSwingAmount * noanimamount;
            float zFront = Math.abs(Mth.m_14031_((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.4f) * limbSwingAmount * noanimamount;
            this.rightHindLeg.f_104204_ += yHind;
            this.leftHindLeg.f_104204_ += -yHind;
            this.rightMiddleLeg.f_104204_ += yMid;
            this.leftMiddleLeg.f_104204_ += -yMid;
            this.rightFrontLeg.f_104204_ += yFront;
            this.leftFrontLeg.f_104204_ += -yFront;
            this.rightHindLeg.f_104205_ += zHind;
            this.leftHindLeg.f_104205_ += -zHind;
            this.rightMiddleLeg.f_104205_ += zMid;
            this.leftMiddleLeg.f_104205_ += -zMid;
            this.rightFrontLeg.f_104205_ += zFront;
            this.leftFrontLeg.f_104205_ += -zFront;
        }
    }
}

