/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.handshake;

import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.HandshakeMessage;
import com.mrcrayfish.framework.network.LoginDataManager;
import com.mrcrayfish.framework.platform.Services;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.CountDownLatch;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class S2CLoginData
extends HandshakeMessage<S2CLoginData> {
    private ResourceLocation id;
    private FriendlyByteBuf data;

    public S2CLoginData() {
    }

    public S2CLoginData(ResourceLocation id, FriendlyByteBuf data) {
        this.id = id;
        this.data = data;
    }

    @Override
    public void encode(S2CLoginData message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.id);
        buffer.m_130130_(message.data.readableBytes());
        buffer.writeBytes((ByteBuf)message.data);
    }

    @Override
    public S2CLoginData decode(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        int readableBytes = buffer.m_130242_();
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.wrappedBuffer((ByteBuf)buffer.readBytes(readableBytes)));
        return new S2CLoginData(id, data);
    }

    @Override
    public void handle(S2CLoginData message, MessageContext context) {
        String[] response = new String[1];
        CountDownLatch block = new CountDownLatch(1);
        context.execute(() -> {
            ILoginData data = LoginDataManager.getLoginDataSupplier(message.id).get();
            data.readData(message.data).ifPresent(s -> {
                response[0] = s;
            });
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        if (response[0] != null) {
            String modName = Services.PLATFORM.getModName(message.id.m_135827_());
            context.getNetworkManager().m_129507_((Component)Component.m_237113_((String)("Connection closed - [" + modName + "] " + response[0])));
            return;
        }
        context.setHandled(true);
        context.reply(new HandshakeMessage.Acknowledge());
    }
}

