/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.mixin;

import com.structureessentials.Timings;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StructureStart.class})
public abstract class StructureStartTimingMixin {
    @Unique
    private long time = 0L;
    @Unique
    private ResourceLocation id = null;

    @Shadow
    public abstract Structure m_226861_();

    @Inject(method={"placeInChunk"}, at={@At(value="HEAD")})
    private void beforeGenerate(WorldGenLevel p_226851_, StructureManager p_226852_, ChunkGenerator p_226853_, RandomSource p_226854_, BoundingBox p_226855_, ChunkPos p_226856_, CallbackInfo ci) {
        this.time = System.nanoTime();
    }

    @Inject(method={"placeInChunk"}, at={@At(value="RETURN")})
    private void afterGenerate(WorldGenLevel worldGenLevel, StructureManager p_226852_, ChunkGenerator p_226853_, RandomSource p_226854_, BoundingBox p_226855_, ChunkPos p_226856_, CallbackInfo ci) {
        long time = (System.nanoTime() - this.time) / 10L;
        if (this.id == null) {
            this.id = ((Registry)worldGenLevel.m_9598_().m_6632_(Registries.f_256944_).get()).m_7981_((Object)this.m_226861_());
        }
        if (this.id != null) {
            Timings.structureTimings.put(this.id, Timings.structureTimings.getOrDefault(this.id, 0L) + time);
        }
    }
}

