/*
 * Decompiled with CFR 0.152.
 */
package com.lootintegrations.loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.lootintegrations.LootintegrationsMod;
import com.lootintegrations.loot.GlobalLootModifierIntegration;
import com.lootintegrations.loot.ILootTableID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;

public class LootModifierManager
extends SimpleJsonResourceReloadListener {
    public static final Map<ResourceLocation, List<GlobalLootModifierIntegration>> lootOptionsMap = new HashMap<ResourceLocation, List<GlobalLootModifierIntegration>>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final TagKey<Item> IGNORED_FOR_LOOT = ItemTags.create((ResourceLocation)new ResourceLocation("lootintegrations:ignored"));
    private static Set<ResourceLocation> applying = new HashSet<ResourceLocation>();

    public LootModifierManager() {
        super(GSON, "loot");
    }

    public static void applyTo(LootContext context, List<ItemStack> items, LootTable lootTable) {
        if (!(lootTable instanceof ILootTableID)) {
            return;
        }
        ResourceLocation lootTableID = ((ILootTableID)lootTable).getID();
        if (applying.contains(lootTableID)) {
            return;
        }
        List<GlobalLootModifierIntegration> modifiers = lootOptionsMap.get(((ILootTableID)lootTable).getID());
        if (modifiers != null && !modifiers.isEmpty()) {
            applying.add(lootTableID);
            for (GlobalLootModifierIntegration modifier : modifiers) {
                modifier.doApply(items, context, lootTable);
            }
            applying.remove(lootTableID);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, ResourceManager iResourceManager, ProfilerFiller iProfiler) {
        lootOptionsMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceLocationJsonElementMap.entrySet()) {
            if (!entry.getKey().m_135827_().equals("lootintegrations")) {
                LootintegrationsMod.LOGGER.warn("Ignoring loot modifiers for:" + entry.getKey() + " use this folder name:lootintegrations");
                continue;
            }
            try {
                GlobalLootModifierIntegration modifier = GlobalLootModifierIntegration.read(entry.getKey(), entry.getValue());
                for (ResourceLocation integratedTable : modifier.integratedTables.keySet()) {
                    lootOptionsMap.computeIfAbsent(integratedTable, e -> new ArrayList()).add(modifier);
                }
            }
            catch (Error e2) {
                LootintegrationsMod.LOGGER.warn("Failed to load loot modifier file:" + entry.getKey(), (Throwable)e2);
            }
        }
    }
}

