/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.core.data.server.modifiers;

import com.google.common.collect.Maps;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.DisplayInfoModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.EffectsChangedModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.ParentModifier;
import com.teamabnormals.blueprint.core.api.conditions.ConfigValueCondition;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.savage_and_ravage.core.SRConfig;
import com.teamabnormals.savage_and_ravage.core.SavageAndRavage;
import com.teamabnormals.savage_and_ravage.core.registry.SRCriteriaTriggers;
import com.teamabnormals.savage_and_ravage.core.registry.SREntityTypes;
import com.teamabnormals.savage_and_ravage.core.registry.SRMobEffects;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.compress.utils.Lists;

public class SRAdvancementModifierProvider
extends AdvancementModifierProvider {
    private static final EntityType<?>[] MOBS_TO_KILL = new EntityType[]{(EntityType)SREntityTypes.SKELETON_VILLAGER.get(), (EntityType)SREntityTypes.CREEPIE.get(), (EntityType)SREntityTypes.ICEOLOGER.get(), (EntityType)SREntityTypes.EXECUTIONER.get(), (EntityType)SREntityTypes.TRICKSTER.get()};

    public SRAdvancementModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("savage_and_ravage", output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        MobEffectsPredicate predicate = MobEffectsPredicate.m_56552_();
        SRMobEffects.MOB_EFFECTS.getEntries().forEach(mobEffect -> predicate.m_56553_((MobEffect)mobEffect.get()));
        this.entry("nether/all_effects").selects(new String[]{"nether/all_effects"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, predicate), new ICondition[0]);
        this.entry("adventure/ol_betsy").selects(new ResourceLocation[]{new ResourceLocation("adventure/ol_betsy")}).addModifier((ObjectModifier)new ParentModifier(new ResourceLocation("adventure/shoot_arrow")), new ICondition[0]);
        CriteriaModifier.Builder killAMob = CriteriaModifier.builder((String)this.modId);
        CriteriaModifier.Builder killAllMobs = CriteriaModifier.builder((String)this.modId);
        ArrayList names = Lists.newArrayList();
        for (EntityType<?> entityType : MOBS_TO_KILL) {
            String name = ForgeRegistries.ENTITY_TYPES.getKey(entityType).m_135815_();
            KilledTrigger.TriggerInstance triggerInstance = KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType));
            killAMob.addCriterion(name, (CriterionTriggerInstance)triggerInstance);
            killAllMobs.addCriterion(name, (CriterionTriggerInstance)triggerInstance);
            names.add(name);
        }
        ConfigValueCondition noBadOmenOnDeath = new ConfigValueCondition(SavageAndRavage.location("config"), (ForgeConfigSpec.ConfigValue)SRConfig.COMMON.noBadOmenOnDeath, "no_bad_omen_on_death", (Map)Maps.newHashMap(), false);
        this.entry("adventure/kill_a_mob").selects(new String[]{"adventure/kill_a_mob"}).addModifier((ObjectModifier)killAMob.addIndexedRequirements(0, false, names.toArray(new String[0])).build(), new ICondition[0]);
        this.entry("adventure/kill_all_mobs").selects(new String[]{"adventure/kill_all_mobs"}).addModifier((ObjectModifier)killAllMobs.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        this.entry("adventure/voluntary_exile").selects(new String[]{"adventure/voluntary_exile"}).addModifier((ObjectModifier)new ParentModifier(new ResourceLocation("adventure/trade")), new ICondition[0]).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("voluntary_exile_burn", (CriterionTriggerInstance)SRCriteriaTriggers.BURN_OMINOUS_BANNER.createInstance()).addIndexedRequirements(0, true, new String[]{"voluntary_exile_burn"}).shouldReplaceRequirements(true).build(), new ICondition[]{noBadOmenOnDeath}).addModifier((ObjectModifier)DisplayInfoModifier.builder().description((Component)Component.m_237115_((String)("advancements." + this.modId + ".adventure.voluntary_exile.description"))).build(), new ICondition[]{noBadOmenOnDeath});
    }
}

