/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.core;

import com.teamabnormals.blueprint.core.annotations.ConfigKey;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SRConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue creeperExplosionsDestroyBlocks;
        public final ForgeConfigSpec.BooleanValue creeperExplosionsSpawnCreepies;
        @ConfigKey(value="creepers_drop_spores_after_explosion_death")
        public final ForgeConfigSpec.BooleanValue creepersDropSporesAfterExplosionDeath;
        public final ForgeConfigSpec.BooleanValue creepieExplosionsDestroyBlocks;
        public final ForgeConfigSpec.BooleanValue evokersUseTotems;
        public final ForgeConfigSpec.BooleanValue reducedVexHealth;
        @ConfigKey(value="no_bad_omen_on_death")
        public final ForgeConfigSpec.BooleanValue noBadOmenOnDeath;
        public final ForgeConfigSpec.BooleanValue improvedIllagerBehavior;
        public final ForgeConfigSpec.BooleanValue poisonPotatoCompat;
        public final ForgeConfigSpec.DoubleValue poisonPotatoChance;
        public final ForgeConfigSpec.BooleanValue poisonPotatoEffect;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("mobs");
            builder.push("creepers");
            this.creeperExplosionsDestroyBlocks = builder.define("Creeper explosions destroy blocks", true);
            this.creeperExplosionsSpawnCreepies = builder.define("Creeper explosions spawn creepies", false);
            this.creepersDropSporesAfterExplosionDeath = builder.define("Creepers drop Creeper Spores after they die from an explosion", true);
            this.creepieExplosionsDestroyBlocks = builder.define("Creepie explosions destroy blocks", false);
            builder.pop();
            builder.push("illagers");
            this.noBadOmenOnDeath = builder.comment(new String[]{"Illagers with banners will no longer give Bad Omen when you kill them", "Instead, you will have to place and burn the banner that they drop with flint and steel or a fire charge"}).define("Illagers no longer give Bad Omen on death", true);
            this.evokersUseTotems = builder.comment(new String[]{"When killed by projectiles, evokers use a totem of undying", "This restores 2 health and gives them a projectile-proof shield for 30 seconds", "When their shield runs out, evokers cannot use totems for another 90 seconds"}).define("Evokers use totems", true);
            this.reducedVexHealth = builder.define("Vex health is reduced to 2", true);
            this.improvedIllagerBehavior = builder.comment("Illagers have a smarter AI when using Crossbows, making them more of a threat in combat").define("Improved Illager behavior", true);
            builder.pop();
            builder.pop();
            builder.push("compat");
            builder.push("poisonous_potato");
            this.poisonPotatoCompat = builder.comment("If baby mobs can be fed a poisonous potato to stunt their growth when Quark is installed").define("Poisonous Potato compat", true);
            this.poisonPotatoChance = builder.comment("The chance to stunt baby mob growth when feeding a poisonous potato").defineInRange("Poisonous Potato stunt chance", 0.1, 0.0, 1.0);
            this.poisonPotatoEffect = builder.comment("If growth stunting should give baby mobs poison").define("Poisonous Potato effect", true);
            builder.pop();
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue creepieSprout;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("mobs");
            builder.push("creepers");
            this.creepieSprout = builder.define("Creepies have a sprout on their head", true);
            builder.pop();
            builder.pop();
        }
    }
}

