/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.common.entity.projectile;

import com.teamabnormals.savage_and_ravage.common.entity.monster.Creepie;
import com.teamabnormals.savage_and_ravage.core.registry.SREntityTypes;
import com.teamabnormals.savage_and_ravage.core.registry.SRParticleTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class SporeCloud
extends ThrowableProjectile
implements IEntityAdditionalSpawnData {
    private AreaEffectCloud cloudEntity;
    private UUID cloudId;
    private int cloudSize;
    private boolean charged = false;
    private boolean spawnCloudInstantly;
    private boolean creepiesAttackPlayersOnly;
    private boolean hit;

    public SporeCloud(EntityType<? extends SporeCloud> type, Level world) {
        super(type, world);
    }

    public SporeCloud(Level world, LivingEntity thrower) {
        super((EntityType)SREntityTypes.SPORE_CLOUD.get(), thrower, world);
    }

    public SporeCloud(Level world, double x, double y, double z) {
        super((EntityType)SREntityTypes.SPORE_CLOUD.get(), x, y, z, world);
    }

    private void spawnAreaEffectCloud(double x, double y, double z) {
        if (this.cloudId != null) {
            return;
        }
        this.m_6034_(x, y, z);
        AreaEffectCloud aoe = new AreaEffectCloud(this.m_9236_(), x, y, z);
        Entity thrower = this.m_19749_();
        if (thrower instanceof LivingEntity) {
            aoe.m_19718_((LivingEntity)thrower);
        }
        aoe.m_19724_((ParticleOptions)SRParticleTypes.CREEPER_SPORES.get());
        aoe.m_19712_((float)this.cloudSize + 1.3f);
        aoe.m_19732_(-0.05f);
        aoe.m_19734_(this.cloudSize * 20 + 60);
        aoe.m_19738_(-aoe.m_19743_() / (float)aoe.m_19748_());
        this.m_9236_().m_7967_((Entity)aoe);
        this.setCloudEntity(aoe);
        this.m_9236_().m_7605_((Entity)this, (byte)3);
    }

    public void setCloudEntity(@Nullable AreaEffectCloud entity) {
        this.cloudEntity = entity;
        this.cloudId = entity == null ? null : entity.m_20148_();
    }

    @Nullable
    private AreaEffectCloud getCloudEntity() {
        if (this.cloudId != null && this.m_9236_() instanceof ServerLevel) {
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.cloudId);
            return entity instanceof AreaEffectCloud ? (AreaEffectCloud)entity : null;
        }
        return null;
    }

    protected void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.cloudId != null) {
            nbt.m_128362_("CloudEntity", this.cloudId);
        }
        if (this.charged) {
            nbt.m_128379_("Charged", true);
        }
        nbt.m_128405_("CloudSize", this.cloudSize);
        nbt.m_128379_("SpawnCloudInstantly", this.spawnCloudInstantly);
        nbt.m_128379_("AttackPlayersOnly", this.creepiesAttackPlayersOnly);
    }

    protected void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.cloudId = nbt.m_128403_("CloudEntity") ? nbt.m_128342_("CloudEntity") : null;
        this.charged = nbt.m_128471_("Charged");
        this.cloudSize = nbt.m_128451_("CloudSize");
        this.spawnCloudInstantly = nbt.m_128471_("SpawnCloudInstantly");
        this.creepiesAttackPlayersOnly = nbt.m_128471_("AttackPlayersOnly");
    }

    protected void m_8097_() {
    }

    protected void m_6532_(HitResult result) {
        Vec3 hitVec = result.m_82450_();
        if (!this.m_9236_().m_5776_()) {
            this.spawnAreaEffectCloud(hitVec.m_7096_(), hitVec.m_7098_(), hitVec.m_7094_());
        } else {
            for (int i = 0; i < 16; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)SRParticleTypes.CREEPER_SPORE_SPRINKLES.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
        this.hit = true;
        if (result instanceof BlockHitResult) {
            this.m_8060_((BlockHitResult)result);
        }
        if (result instanceof EntityHitResult) {
            this.m_5790_((EntityHitResult)result);
        }
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 3) {
            this.hit = true;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.spawnCloudInstantly) {
            this.spawnAreaEffectCloud(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.cloudId != null || this.hit) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        if (this.m_9236_().m_5776_()) {
            if (!this.hit) {
                this.m_9236_().m_7106_((ParticleOptions)SRParticleTypes.CREEPER_SPORES.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        } else if (this.cloudId != null) {
            AreaEffectCloud aoe = this.getCloudEntity();
            if (aoe == null) {
                if (this.cloudEntity == null || !this.cloudEntity.m_6084_()) {
                    this.m_146870_();
                }
                return;
            }
            Creepie creepie = (Creepie)((EntityType)SREntityTypes.CREEPIE.get()).m_20615_(this.m_9236_());
            if (creepie != null) {
                Entity thrower;
                if (this.charged) {
                    creepie.setCharged(true);
                }
                creepie.attackPlayersOnly = this.creepiesAttackPlayersOnly();
                if (!creepie.attackPlayersOnly) {
                    creepie.m_21530_();
                }
                if ((thrower = this.m_19749_()) instanceof LivingEntity && !thrower.m_20145_()) {
                    creepie.setOwnerId(thrower.m_20148_());
                }
                BlockPos nextPosition = null;
                if (aoe.f_19797_ % 20 == 0) {
                    for (int i = 0; i < 10; ++i) {
                        double xPos = aoe.m_20208_(0.1);
                        double zPos = aoe.m_20262_(0.2);
                        creepie.m_7678_(xPos, aoe.m_20186_(), zPos, 0.0f, 0.0f);
                        AABB box = creepie.m_20191_();
                        if (!BlockPos.m_121886_((int)Mth.m_14107_((double)box.f_82288_), (int)Mth.m_14107_((double)box.f_82289_), (int)Mth.m_14107_((double)box.f_82290_), (int)Mth.m_14165_((double)box.f_82291_), (int)Mth.m_14165_((double)box.f_82292_), (int)Mth.m_14165_((double)box.f_82293_)).distinct().noneMatch(pos -> {
                            if (this.m_9236_().m_8055_(pos).m_60828_((BlockGetter)this.m_9236_(), pos)) {
                                for (AABB blockBox : this.m_9236_().m_8055_(pos).m_60808_((BlockGetter)this.m_9236_(), pos).m_83299_()) {
                                    blockBox = new AABB(blockBox.f_82288_ + (double)pos.m_123341_(), blockBox.f_82289_ + (double)pos.m_123342_(), blockBox.f_82290_ + (double)pos.m_123343_(), blockBox.f_82291_ + (double)pos.m_123341_(), blockBox.f_82292_ + (double)pos.m_123342_(), blockBox.f_82293_ + (double)pos.m_123343_());
                                    if (!blockBox.m_82381_(creepie.m_20191_())) continue;
                                    return true;
                                }
                            }
                            return false;
                        })) continue;
                        nextPosition = BlockPos.m_274561_((double)xPos, (double)aoe.m_20186_(), (double)zPos);
                        break;
                    }
                    if (nextPosition != null) {
                        this.m_9236_().m_7967_((Entity)creepie);
                    }
                }
                if (!aoe.m_6084_()) {
                    this.m_146870_();
                }
            }
        }
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setCloudSize(int cloudSize) {
        this.cloudSize = cloudSize;
    }

    public void setSpawnCloudInstantly(boolean spawnCloudInstantly) {
        this.spawnCloudInstantly = spawnCloudInstantly;
    }

    public void setCharged(boolean charged) {
        this.charged = charged;
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        buf.writeBoolean(this.cloudId != null);
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.hit = buf.readBoolean();
    }

    public boolean creepiesAttackPlayersOnly() {
        return this.creepiesAttackPlayersOnly;
    }

    public void creepiesAttackPlayersOnly(boolean creepiesAttackPlayersOnly) {
        this.creepiesAttackPlayersOnly = creepiesAttackPlayersOnly;
    }
}

