/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.common.entity.projectile;

import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.savage_and_ravage.common.entity.TracksHits;
import com.teamabnormals.savage_and_ravage.core.other.SREvents;
import com.teamabnormals.savage_and_ravage.core.registry.SRBlocks;
import com.teamabnormals.savage_and_ravage.core.registry.SREntityTypes;
import com.teamabnormals.savage_and_ravage.core.registry.SRMobEffects;
import com.teamabnormals.savage_and_ravage.core.registry.SRParticleTypes;
import com.teamabnormals.savage_and_ravage.core.registry.SRSoundEvents;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ConfusionBolt
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> TICKS_TILL_REMOVE = SynchedEntityData.m_135353_(ConfusionBolt.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ConfusionBolt(EntityType<? extends ConfusionBolt> type, Level world) {
        super(type, world);
        this.m_20242_(true);
    }

    public ConfusionBolt(Level world, LivingEntity thrower, int ticksTillRemove) {
        super((EntityType)SREntityTypes.CONFUSION_BOLT.get(), thrower, world);
        this.m_20242_(true);
        this.f_19804_.m_135381_(TICKS_TILL_REMOVE, (Object)ticksTillRemove);
    }

    public ConfusionBolt(Level world, double x, double y, double z, int ticksTillRemove) {
        super((EntityType)SREntityTypes.CONFUSION_BOLT.get(), x, y, z, world);
        this.m_20242_(true);
        this.f_19804_.m_135381_(TICKS_TILL_REMOVE, (Object)ticksTillRemove);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TICKS_TILL_REMOVE, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        this.f_19804_.m_135381_(TICKS_TILL_REMOVE, (Object)compound.m_128451_("TicksTillRemove"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("TicksTillRemove", ((Integer)this.f_19804_.m_135370_(TICKS_TILL_REMOVE)).intValue());
    }

    public void m_8119_() {
        List intersecting;
        HitResult result;
        Vec3 deltaMovement = this.m_20184_();
        super.m_8119_();
        this.m_20256_(deltaMovement);
        ConfusionBolt.spawnGaussianParticles(this.m_9236_(), this.f_19796_, this.m_20191_(), SRParticleTypes.CONFUSION_BOLT.getId().toString(), 5);
        this.f_19804_.m_135381_(TICKS_TILL_REMOVE, (Object)((Integer)this.f_19804_.m_135370_(TICKS_TILL_REMOVE) - 1));
        if ((Integer)this.f_19804_.m_135370_(TICKS_TILL_REMOVE) <= 0) {
            this.m_146870_();
        }
        if (!this.m_9236_().m_5776_() && (result = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0))).m_6662_() == HitResult.Type.MISS && this.m_6084_() && !(intersecting = this.m_9236_().m_6443_(Entity.class, this.m_20191_(), x$0 -> this.m_5603_((Entity)x$0))).isEmpty()) {
            this.m_6532_((HitResult)new EntityHitResult((Entity)intersecting.get(0)));
        }
    }

    public static void spawnGaussianParticles(Level world, RandomSource random, AABB box, String name, int loops) {
        if (!world.f_46443_) {
            for (int i = 0; i < loops; ++i) {
                double x = box.m_82340_(Direction.Axis.X) + (0.5 + random.m_188583_() * 0.25) * box.m_82362_();
                double y = box.m_82340_(Direction.Axis.Y) + (0.5 + random.m_188583_() * 0.25) * box.m_82376_();
                double z = box.m_82340_(Direction.Axis.Z) + (0.5 + random.m_188583_() * 0.25) * box.m_82385_();
                NetworkUtil.spawnParticle((String)name, (ResourceKey)world.m_46472_(), (double)x, (double)y, (double)z, (double)0.0, (double)0.0, (double)0.0);
            }
        }
    }

    protected void m_6532_(HitResult result) {
        this.m_5496_((SoundEvent)SRSoundEvents.GENERIC_PUFF_OF_SMOKE.get(), 5.0f, 1.0f);
        ConfusionBolt.spawnGaussianParticles(this.m_9236_(), this.f_19796_, this.m_20191_().m_82400_(0.5), SREvents.POOF_KEY, 25);
        super.m_6532_(result);
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        Entity owner = this.m_19749_();
        if (owner != null && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Vec3 oldPos = owner.m_20182_();
            this.teleport(owner, living.m_20185_(), living.m_20186_(), living.m_20189_());
            this.teleport((Entity)living, oldPos.m_7096_(), oldPos.m_7098_(), oldPos.m_7094_());
            if (living.m_5801_()) {
                living.m_7292_(new MobEffectInstance((MobEffect)SRMobEffects.WEIGHT.get(), 140, 2));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 140, 1));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 30));
            }
            living.m_5496_((SoundEvent)SRSoundEvents.GENERIC_PUFF_OF_SMOKE.get(), 5.0f, 1.0f);
            ConfusionBolt.spawnGaussianParticles(this.m_9236_(), this.f_19796_, living.m_20191_().m_82400_(0.5), SREvents.POOF_KEY, 25);
            if (owner instanceof TracksHits) {
                TracksHits tracksHits = (TracksHits)owner;
                tracksHits.onTrackedHit((Entity)this, entity);
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().f_46443_) {
            BlockPos.MutableBlockPos pos = result.m_82425_().m_122032_();
            if (this.m_9236_().m_8055_((BlockPos)pos).m_60734_() == SRBlocks.GLOOMY_TILES.get()) {
                this.m_9236_().m_7731_((BlockPos)pos, ((Block)SRBlocks.RUNED_GLOOMY_TILES.get()).m_49966_(), 2);
                for (Direction direction : Direction.values()) {
                    pos.m_122173_(direction);
                    if (!this.m_9236_().m_8055_((BlockPos)pos).m_60804_((BlockGetter)this.m_9236_(), (BlockPos)pos)) {
                        for (int i = 0; i < 3; ++i) {
                            NetworkUtil.spawnParticle((String)SRParticleTypes.RUNE.getId().toString(), (ResourceKey)this.m_9236_().m_46472_(), (double)((double)pos.m_123341_() + this.f_19796_.m_188500_()), (double)((double)pos.m_123342_() + 0.25), (double)((double)pos.m_123343_() + this.f_19796_.m_188500_()), (double)0.0, (double)0.0, (double)0.0);
                        }
                    }
                    pos.m_122173_(direction.m_122424_());
                }
            }
        }
    }

    private void teleport(Entity entity, double x, double y, double z) {
        Mob mob;
        Vec3 originalPos = entity.m_20182_();
        if (!entity.m_9236_().m_5776_()) {
            NetworkUtil.teleportEntity((Entity)entity, (double)x, (double)y, (double)z);
        }
        if (!(entity instanceof Mob) || !(mob = (Mob)entity).m_21525_()) {
            entity.m_7618_(EntityAnchorArgument.Anchor.EYES, originalPos);
        }
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

