/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.events;

import com.pyzpre.createbitterballen.block.sunflower.SunflowerStem;
import com.pyzpre.createbitterballen.index.BlockRegistry;
import com.pyzpre.createbitterballen.index.EffectRegistry;
import com.pyzpre.createbitterballen.index.FluidRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityEffectHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean isInitialized = false;

    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (!level.f_46443_) {
            for (Player player : level.m_6907_()) {
                BlockPos playerPos = player.m_20183_();
                AABB dynamicBounds = new AABB((double)(playerPos.m_123341_() - 16), (double)(playerPos.m_123342_() - 16), (double)(playerPos.m_123343_() - 16), (double)(playerPos.m_123341_() + 16), (double)(playerPos.m_123342_() + 16), (double)(playerPos.m_123343_() + 16));
                for (Entity entity : level.m_45933_(null, dynamicBounds)) {
                    LivingEntity livingEntity;
                    if (!(entity instanceof LivingEntity) || !this.isInFryingOil(livingEntity = (LivingEntity)entity, level)) continue;
                    this.applyOilEffect(livingEntity);
                }
            }
        }
    }

    private boolean isInFryingOil(LivingEntity entity, Level level) {
        BlockPos pos = entity.m_20183_();
        FluidState fluidState = level.m_6425_(pos);
        Fluid fluid = fluidState.m_76152_();
        boolean isFryingOil = fluid.m_6212_((Fluid)FluidRegistry.FRYING_OIL.get());
        return isFryingOil;
    }

    private void applyOilEffect(LivingEntity entity) {
        MobEffectInstance oiledup = new MobEffectInstance((MobEffect)EffectRegistry.OILED_UP.get(), 200, 1);
        if (!entity.m_21023_((MobEffect)EffectRegistry.OILED_UP.get())) {
            entity.m_7292_(oiledup);
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Chicken) {
            Chicken chicken = (Chicken)entity;
            chicken.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)chicken, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{((SunflowerStem)((Object)BlockRegistry.SUNFLOWERSTEM.get())).m_5456_()}), false));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!event.getLevel().m_5776_()) {
            Entity target = event.getTarget();
            Player player = event.getEntity();
            ItemStack heldItem = player.m_21120_(event.getHand());
            if (target instanceof Chicken) {
                Chicken chicken = (Chicken)target;
                if (heldItem.m_41720_() == ((SunflowerStem)((Object)BlockRegistry.SUNFLOWERSTEM.get())).m_5456_() && chicken.m_6084_() && !chicken.m_6162_() && !chicken.m_27593_()) {
                    if (!player.m_150110_().f_35937_) {
                        heldItem.m_41774_(1);
                    }
                    chicken.m_27595_(player);
                    player.m_21011_(event.getHand(), true);
                    Level level = player.m_9236_();
                    level.m_7605_((Entity)chicken, (byte)18);
                    event.setCanceled(true);
                }
            }
        }
    }
}

