/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.handler;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.config.Config;
import com.bawnorton.neruina.handler.TickHandler;
import com.bawnorton.neruina.thread.ConditionalRunnable;
import com.bawnorton.neruina.util.ErroredType;
import com.bawnorton.neruina.util.TickingEntry;
import com.bawnorton.neruina.version.VersionedText;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class MessageHandler {
    public void broadcastToPlayers(MinecraftServer server, Component message) {
        ConditionalRunnable.create(() -> {
            switch (Config.getInstance().logLevel) {
                case DISABLED: {
                    break;
                }
                case EVERYONE: {
                    server.m_6846_().m_11314_().forEach(player -> player.m_5661_(message, false));
                    break;
                }
                case OPERATORS: {
                    server.m_6846_().m_11314_().stream().filter(player -> server.m_129944_(player.m_36316_()) >= server.m_7022_()).forEach(player -> player.m_5661_(message, false));
                }
            }
        }, () -> server.m_6846_().m_11309_() > 0);
    }

    public void broadcastToPlayers(MinecraftServer server, Component ... messages) {
        this.broadcastToPlayers(server, VersionedText.pad(VersionedText.concatDelimited(VersionedText.LINE_BREAK, messages)));
    }

    public void sendToPlayer(Player player, Component message, Component ... actions) {
        this.sendToPlayer(player, message, true, actions);
    }

    public void sendToPlayer(Player player, Component message, boolean pad, Component ... actions) {
        message = VersionedText.concatDelimited(VersionedText.LINE_BREAK, VersionedText.format(message), actions != null ? VersionedText.concatDelimited(VersionedText.LINE_BREAK, actions) : null);
        player.m_5661_(pad ? VersionedText.pad(message) : message, false);
    }

    public Component generateEntityActions(Entity entity) {
        return VersionedText.concatDelimited(VersionedText.SPACE, this.generateHandlingActions(ErroredType.ENTITY, (ResourceKey<Level>)entity.m_9236_().m_46472_(), entity.m_20183_(), entity.m_20148_()), this.generateKillAction(entity.m_20148_()));
    }

    public Component generateResourceActions(TickingEntry entry) {
        return VersionedText.concatDelimited(VersionedText.SPACE, this.generateInfoAction(), this.generateCopyCrashAction(entry), this.generateReportAction(entry));
    }

    public Component generateHandlingActions(ErroredType type, ResourceKey<Level> dimension, BlockPos pos) {
        return this.generateHandlingActions(type, dimension, pos, null);
    }

    public Component generateHandlingActions(ErroredType type, ResourceKey<Level> dimension, BlockPos pos, @Nullable UUID uuid) {
        return VersionedText.concatDelimited(VersionedText.SPACE, this.generateTeleportAction(type, dimension, pos), this.generateResumeAction(type, uuid != null ? uuid.toString() : this.posAsNums(pos)));
    }

    public Component generateKillAction(UUID uuid) {
        return this.generateCommandAction("neruina.kill", ChatFormatting.DARK_RED, "/neruina kill %s".formatted(uuid));
    }

    public Component generateCopyCrashAction(TickingEntry entry) {
        StringWriter traceString = new StringWriter();
        PrintWriter writer = new PrintWriter(traceString);
        entry.error().printStackTrace(writer);
        String trace = traceString.toString();
        writer.flush();
        writer.close();
        return this.generateAction("neruina.copy_crash", ChatFormatting.GOLD, ClickEvent.Action.COPY_TO_CLIPBOARD, trace);
    }

    public Component generateReportAction(TickingEntry entry) {
        return this.generateCommandAction("neruina.report", ChatFormatting.LIGHT_PURPLE, "/neruina report %s".formatted(entry.uuid()));
    }

    public Component generateTeleportAction(ErroredType type, ResourceKey<Level> dimension, BlockPos pos) {
        return this.generateCommandAction("neruina.teleport", "neruina.teleport.%s.tooltip".formatted(type.getName()), ChatFormatting.DARK_AQUA, "/execute in %s run tp @s %s".formatted(dimension.m_135782_().toString(), this.posAsNums(pos)));
    }

    public Component generateInfoAction() {
        return this.generateAction("neruina.info", ChatFormatting.GREEN, ClickEvent.Action.OPEN_URL, "https://github.com/Bawnorton/Neruina/wiki/What-Is-This%3F");
    }

    public Component generateResumeAction(ErroredType type, String args) {
        return this.generateCommandAction("neruina.try_resume", "neruina.try_resume.%s.tooltip".formatted(type.getName()), ChatFormatting.YELLOW, "/neruina resume %s %s".formatted(type.getName(), args));
    }

    public Component generateClearAction() {
        return this.generateCommandAction("neruina.clear", ChatFormatting.BLUE, "/neruina clear_tracked");
    }

    public Component generateOpenReportAction(String url) {
        return this.generateAction("neruina.open_report", ChatFormatting.LIGHT_PURPLE, ClickEvent.Action.OPEN_URL, url);
    }

    public Component generateCancelLoginAction() {
        return this.generateCommandAction("neruina.cancel", ChatFormatting.DARK_RED, "/neruina cancel_login");
    }

    private Component generateCommandAction(String key, ChatFormatting color, String command) {
        return this.generateCommandAction(key, "%s.tooltip".formatted(key), color, command);
    }

    private Component generateCommandAction(String key, String hoverKey, ChatFormatting color, String command) {
        return this.generateAction(key, hoverKey, color, ClickEvent.Action.RUN_COMMAND, command);
    }

    private Component generateCommandAction(Component message, String hoverKey, ChatFormatting color, String command) {
        return this.generateCommandAction(message, VersionedText.translatable(hoverKey, new Object[0]), color, command);
    }

    private Component generateCommandAction(Component message, Component hoverMessage, ChatFormatting color, String command) {
        return this.generateAction(message, hoverMessage, color, ClickEvent.Action.RUN_COMMAND, command);
    }

    private Component generateAction(String key, ChatFormatting color, ClickEvent.Action action, String value) {
        return this.generateAction(key, "%s.tooltip".formatted(key), color, action, value);
    }

    private Component generateAction(String key, String hoverKey, ChatFormatting color, ClickEvent.Action action, String value) {
        return this.generateAction(VersionedText.translatable(key, new Object[0]), VersionedText.translatable(hoverKey, new Object[0]), color, action, value);
    }

    private Component generateAction(Component message, Component hoverMessage, ChatFormatting color, ClickEvent.Action action, String value) {
        return ComponentUtils.m_130748_((Component)VersionedText.withStyle(message, style -> style.m_131140_(color).m_131142_(new ClickEvent(action, value)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverMessage))));
    }

    public Component generateSuspendedInfo() {
        TickHandler tickHandler = Neruina.getInstance().getTickHandler();
        ArrayList<Component> tickingEntryMessages = new ArrayList<Component>();
        int count = tickHandler.getTickingEntries().size();
        if (count == 1) {
            tickingEntryMessages.add(this.formatText("neruina.ticking_entries.count.single", new Object[0]));
        } else {
            tickingEntryMessages.add(this.formatText("neruina.ticking_entries.count", count));
        }
        tickHandler.getTickingEntries().forEach(entry -> tickingEntryMessages.add(this.generateCommandAction(VersionedText.translatable("neruina.ticking_entries.entry", entry.getCauseName(), this.posAsNums(entry.pos())), "neruina.ticking_entries.entry.tooltip", ChatFormatting.DARK_RED, "/neruina info %s".formatted(entry.uuid()))));
        tickingEntryMessages.add(VersionedText.concatDelimited(VersionedText.SPACE, this.generateInfoAction(), this.generateClearAction()));
        return VersionedText.concatDelimited(VersionedText.LINE_BREAK, tickingEntryMessages.toArray(new Component[0]));
    }

    public Component formatText(String key, Object ... args) {
        return VersionedText.format(VersionedText.translatable(key, args));
    }

    public String posAsNums(BlockPos pos) {
        return "%s %s %s".formatted(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }
}

