/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.other;

import com.teamabnormals.blueprint.core.api.BlockSetTypeRegistryHelper;
import com.teamabnormals.blueprint.core.api.WoodTypeRegistryHelper;
import com.teamabnormals.blueprint.core.util.PropertyUtil;
import com.teamabnormals.environmental.common.block.WallHibiscusBlock;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;

public class EnvironmentalProperties {
    public static final BlockSetType WILLOW_BLOCK_SET = EnvironmentalProperties.blockSetType("willow");
    public static final BlockSetType PINE_BLOCK_SET = EnvironmentalProperties.blockSetType("pine");
    public static final BlockSetType PLUM_BLOCK_SET = EnvironmentalProperties.blockSetType("plum");
    public static final BlockSetType WISTERIA_BLOCK_SET = EnvironmentalProperties.blockSetType("wisteria");
    public static final WoodType WILLOW_WOOD_TYPE = EnvironmentalProperties.woodSetType(WILLOW_BLOCK_SET);
    public static final WoodType PINE_WOOD_TYPE = EnvironmentalProperties.woodSetType(PINE_BLOCK_SET);
    public static final WoodType PLUM_WOOD_TYPE = EnvironmentalProperties.woodSetType(PLUM_BLOCK_SET);
    public static final WoodType WISTERIA_WOOD_TYPE = EnvironmentalProperties.woodSetType(WISTERIA_BLOCK_SET);
    public static final PropertyUtil.WoodSetProperties WILLOW = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283856_, (MapColor)MapColor.f_283825_).build();
    public static final PropertyUtil.WoodSetProperties PINE = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283907_, (MapColor)MapColor.f_283825_).build();
    public static final PropertyUtil.WoodSetProperties PLUM = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283798_, (MapColor)MapColor.f_283825_).leavesColor(MapColor.f_283765_).build();
    public static final PropertyUtil.WoodSetProperties WISTERIA = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283919_, (MapColor)MapColor.f_283846_).leavesColor(MapColor.f_283811_).build();
    public static final PropertyUtil.WoodSetProperties PINK_WISTERIA = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283919_, (MapColor)MapColor.f_283846_).leavesColor(MapColor.f_283765_).build();
    public static final PropertyUtil.WoodSetProperties BLUE_WISTERIA = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283919_, (MapColor)MapColor.f_283846_).leavesColor(MapColor.f_283869_).build();
    public static final PropertyUtil.WoodSetProperties PURPLE_WISTERIA = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283919_, (MapColor)MapColor.f_283846_).leavesColor(MapColor.f_283889_).build();
    public static final PropertyUtil.WoodSetProperties HIBISCUS = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283784_).build();
    public static final BlockBehaviour.Properties CATTAIL = BlockBehaviour.Properties.m_284310_().m_60966_().m_60910_().m_60977_().m_60918_(SoundType.f_56752_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties CATTAIL_STALK = BlockBehaviour.Properties.m_284310_().m_60966_().m_60910_().m_60918_(SoundType.f_56752_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties DUCKWEED = BlockBehaviour.Properties.m_284310_().m_60966_().m_60910_().m_60918_(SoundType.f_56758_).m_278166_(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties MYCELIUM_SPROUTS = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_280170_().m_60910_().m_60966_().m_60918_(SoundType.f_56722_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278183_().m_278166_(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties CUP_LICHEN = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283769_).m_280170_().m_60910_().m_60966_().m_60918_(SoundType.f_56722_).m_278183_().m_278166_(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties CACTUS_BOBBLE = BlockBehaviour.Properties.m_284310_().m_280170_().m_60910_().m_60966_().m_60918_(SoundType.f_56745_).m_278183_().m_278166_(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties DWARF_SPRUCE = BlockBehaviour.Properties.m_284310_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_278166_(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties TALL_FLOWERS = PropertyUtil.flower().m_278183_();
    public static final BlockBehaviour.Properties WALL_HIBISCUS = EnvironmentalProperties.wallHibiscus();
    public static final BlockBehaviour.Properties PINECONE = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60978_(1.5f).m_60918_(SoundType.f_56736_).m_278183_();
    public static final BlockBehaviour.Properties DIRT_PATH = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60978_(0.65f).m_60918_(SoundType.f_56739_).m_60971_(PropertyUtil::always).m_60960_(PropertyUtil::always);
    public static final BlockBehaviour.Properties MYCELIUM_PATH = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60978_(0.65f).m_60918_(SoundType.f_56740_).m_60971_(PropertyUtil::always).m_60960_(PropertyUtil::always);
    public static final BlockBehaviour.Properties PODZOL_PATH = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283819_).m_60978_(0.65f).m_60918_(SoundType.f_56740_).m_60971_(PropertyUtil::always).m_60960_(PropertyUtil::always);
    public static final BlockBehaviour.Properties DIRT_BRICKS = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60978_(0.5f).m_60918_(SoundType.f_56739_);
    public static final BlockBehaviour.Properties MUD_BRICKS = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283907_).m_60999_().m_60913_(1.5f, 3.0f).m_60918_(SoundType.f_222470_);
    public static final BlockBehaviour.Properties YAK_HAIR_BLOCK = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60978_(0.8f).m_60918_(SoundType.f_56745_).m_60955_().m_278183_();
    public static final BlockBehaviour.Properties YAK_HAIR_RUG = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60978_(0.1f).m_60918_(SoundType.f_56745_).m_60955_().m_278183_();
    public static final BlockBehaviour.Properties GRASS_THATCH = PropertyUtil.thatch((MapColor)MapColor.f_283832_, (SoundType)SoundType.f_56740_);
    public static final BlockBehaviour.Properties DUCKWEED_THATCH = PropertyUtil.thatch((MapColor)MapColor.f_283784_, (SoundType)SoundType.f_56740_);
    public static final BlockBehaviour.Properties CATTAIL_THATCH = PropertyUtil.thatch((MapColor)MapColor.f_283856_, (SoundType)SoundType.f_56740_);
    public static final BlockBehaviour.Properties BURIED_TRUFFLE = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60978_(0.6f).m_60918_(SoundType.f_56739_);

    public static BlockSetType blockSetType(String name) {
        return BlockSetTypeRegistryHelper.register((BlockSetType)new BlockSetType("environmental:" + name));
    }

    public static WoodType woodSetType(BlockSetType type) {
        return WoodTypeRegistryHelper.registerWoodType((WoodType)new WoodType(type.f_271253_(), type));
    }

    public static BlockBehaviour.Properties wallHibiscus() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_278183_().m_278166_(PushReaction.DESTROY);
        properties.f_271289_ = Optional.of((state, level, pos) -> {
            Block block = state.m_60734_();
            long i = Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_123342_(), (int)pos.m_123343_());
            float f = block.m_142740_();
            double d0 = Mth.m_14008_((double)(((double)((float)(i & 0xFL) / 15.0f) - 0.5) * 0.4), (double)(-f), (double)f);
            double d1 = Mth.m_14008_((double)(((double)((float)(i >> 8 & 0xFL) / 15.0f) - 0.5) * 0.4), (double)(-f), (double)f);
            Direction facing = (Direction)state.m_61143_((Property)WallHibiscusBlock.FACING);
            Direction.Axis axis = facing.m_122434_();
            Vec3 vec3 = state.m_61143_(WallHibiscusBlock.FACE) != AttachFace.WALL ? new Vec3(d0, 0.0, d1) : (axis == Direction.Axis.X ? new Vec3(0.0, d0, d1) : new Vec3(d0, d1, 0.0));
            return vec3;
        });
        return properties;
    }
}

