/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.other;

import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.environmental.common.entity.projectile.ThrownDuckEgg;
import com.teamabnormals.environmental.common.entity.projectile.ThrownMudBall;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class EnvironmentalCompat {
    public static DispenseItemBehavior EMPTY_FISH_BUCKET_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            DispensibleContainerItem item = (DispensibleContainerItem)stack.m_41720_();
            BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel level = source.m_7727_();
            if (item.emptyContents(null, (Level)level, pos, null, stack)) {
                item.m_142131_(null, (Level)level, stack, pos);
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            return this.defaultDispenseItemBehavior.m_6115_(source, stack);
        }
    };

    public static void register() {
        EnvironmentalCompat.registerCompostables();
        EnvironmentalCompat.registerFlammables();
        EnvironmentalCompat.registerDispenserBehaviors();
        EnvironmentalCompat.changeLocalization();
    }

    private static void changeLocalization() {
        DataUtil.changeBlockLocalization((Block)Blocks.f_152481_, (String)"environmental", (String)"grass_path");
    }

    public static void registerCompostables() {
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.LARGE_LILY_PAD.get()), (float)0.85f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.GIANT_LILY_PAD.get()), (float)1.0f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.HANGING_WILLOW_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PINECONE.get()), (float)0.85f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.CHEERFUL_PLUM_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.CHEERFUL_PLUM_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.MOODY_PLUM_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.MOODY_PLUM_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalItems.CHERRIES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.CHERRY_CRATE.get()), (float)1.0f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalItems.PLUM.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_CRATE.get()), (float)1.0f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalItems.CATTAIL_FLUFF.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.CATTAIL_FLUFF_BLOCK.get()), (float)1.0f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.DUCKWEED.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.CATTAIL.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.GIANT_TALL_GRASS.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.MYCELIUM_SPROUTS.get()), (float)0.5f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.CUP_LICHEN.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.DWARF_SPRUCE.get()), (float)0.5f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalItems.TRUFFLE.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.CATTAIL_THATCH.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.CATTAIL_THATCH_SLAB.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.CATTAIL_THATCH_STAIRS.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.DUCKWEED_THATCH.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.DUCKWEED_THATCH_SLAB.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.DUCKWEED_THATCH_STAIRS.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.GRASS_THATCH.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.GRASS_THATCH_SLAB.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.GRASS_THATCH_STAIRS.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.BLUE_HANGING_WISTERIA_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.WHITE_HANGING_WISTERIA_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PINK_HANGING_WISTERIA_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PURPLE_HANGING_WISTERIA_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.BLUE_WISTERIA_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.WHITE_WISTERIA_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PINK_WISTERIA_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PURPLE_WISTERIA_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.CARTWHEEL.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.VIOLET.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.DIANTHUS.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.RED_LOTUS_FLOWER.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.WHITE_LOTUS_FLOWER.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.BLUEBELL.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.TASSELFLOWER.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.YELLOW_HIBISCUS.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.ORANGE_HIBISCUS.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.RED_HIBISCUS.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PINK_HIBISCUS.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.MAGENTA_HIBISCUS.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PURPLE_HIBISCUS.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.HIBISCUS_LEAVES.get()), (float)0.5f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.BLUE_DELPHINIUM.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.WHITE_DELPHINIUM.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PINK_DELPHINIUM.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.PURPLE_DELPHINIUM.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)EnvironmentalBlocks.BIRD_OF_PARADISE.get()), (float)0.65f);
    }

    public static void registerFlammables() {
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.YAK_HAIR_BLOCK.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.YAK_HAIR_RUG.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CATTAIL_FLUFF_BLOCK.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.GRASS_THATCH.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.GRASS_THATCH_STAIRS.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.GRASS_THATCH_SLAB.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CATTAIL_THATCH.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CATTAIL_THATCH_STAIRS.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CATTAIL_THATCH_SLAB.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DUCKWEED_THATCH.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DUCKWEED_THATCH_STAIRS.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DUCKWEED_THATCH_SLAB.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.HIBISCUS_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.HIBISCUS_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.HANGING_WILLOW_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_WILLOW_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_WILLOW_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_BOARDS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_PINE_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_PINE_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_BOARDS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINECONE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_PLUM_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_PLUM_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CHERRY_CRATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_CRATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_BOARDS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.MOODY_PLUM_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.MOODY_PLUM_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.GIANT_TALL_GRASS.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.MYCELIUM_SPROUTS.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CUP_LICHEN.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_SOUL_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_SOUL_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_REDSTONE_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_REDSTONE_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_ENDER_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_ENDER_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_CUPRIC_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_CUPRIC_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.BLUE_HANGING_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WHITE_HANGING_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINK_HANGING_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PURPLE_HANGING_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_WISTERIA_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_WISTERIA_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.BLUE_DELPHINIUM.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WHITE_DELPHINIUM.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINK_DELPHINIUM.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PURPLE_DELPHINIUM.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_BOARDS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAF_PILE.get()), (int)30, (int)60);
    }

    public static void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)EnvironmentalItems.DUCK_EGG.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
                return new ThrownDuckEgg(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_());
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)EnvironmentalItems.MUD_BALL.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
                return new ThrownMudBall(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_());
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)EnvironmentalItems.KOI_BUCKET.get()), (DispenseItemBehavior)EMPTY_FISH_BUCKET_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)EnvironmentalItems.SLABFISH_BUCKET.get()), (DispenseItemBehavior)EMPTY_FISH_BUCKET_BEHAVIOR);
    }
}

