/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.client;

import com.teamabnormals.blueprint.core.data.client.BlueprintItemModelProvider;
import com.teamabnormals.environmental.common.entity.animal.koi.KoiBreed;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.slabfish.EnvironmentalSlabfishTypes;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class EnvironmentalItemModelProvider
extends BlueprintItemModelProvider {
    public EnvironmentalItemModelProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "environmental", helper);
    }

    protected void registerModels() {
        this.generatedItem(new RegistryObject[]{(RegistryObject)EnvironmentalItems.WILLOW_BOAT.getFirst(), (RegistryObject)EnvironmentalItems.WILLOW_BOAT.getSecond(), EnvironmentalItems.WILLOW_FURNACE_BOAT, EnvironmentalItems.LARGE_WILLOW_BOAT, (RegistryObject)EnvironmentalItems.PINE_BOAT.getFirst(), (RegistryObject)EnvironmentalItems.PINE_BOAT.getSecond(), EnvironmentalItems.PINE_FURNACE_BOAT, EnvironmentalItems.LARGE_PINE_BOAT, (RegistryObject)EnvironmentalItems.WISTERIA_BOAT.getFirst(), (RegistryObject)EnvironmentalItems.WISTERIA_BOAT.getSecond(), EnvironmentalItems.WISTERIA_FURNACE_BOAT, EnvironmentalItems.LARGE_WISTERIA_BOAT, (RegistryObject)EnvironmentalItems.PLUM_BOAT.getFirst(), (RegistryObject)EnvironmentalItems.PLUM_BOAT.getSecond(), EnvironmentalItems.PLUM_FURNACE_BOAT, EnvironmentalItems.LARGE_PLUM_BOAT, EnvironmentalItems.LUMBERER_BANNER_PATTERN, EnvironmentalItems.HELPER_BANNER_PATTERN, EnvironmentalItems.CATTAIL_FLUFF, EnvironmentalBlocks.CATTAIL, EnvironmentalItems.CHERRIES, EnvironmentalItems.PLUM, EnvironmentalItems.VENISON, EnvironmentalItems.COOKED_VENISON, EnvironmentalItems.DUCK_EGG, EnvironmentalItems.DUCK, EnvironmentalItems.COOKED_DUCK, EnvironmentalItems.TRUFFLE, EnvironmentalItems.YAK_HAIR, EnvironmentalItems.KOI, EnvironmentalItems.MUD_BALL, EnvironmentalItems.MUSIC_DISC_LEAVING_HOME, EnvironmentalItems.MUSIC_DISC_SLABRAVE});
        this.spawnEggItem(new RegistryObject[]{EnvironmentalItems.SLABFISH_SPAWN_EGG, EnvironmentalItems.DUCK_SPAWN_EGG, EnvironmentalItems.DEER_SPAWN_EGG, EnvironmentalItems.REINDEER_SPAWN_EGG, EnvironmentalItems.YAK_SPAWN_EGG, EnvironmentalItems.KOI_SPAWN_EGG, EnvironmentalItems.TAPIR_SPAWN_EGG, EnvironmentalItems.ZEBRA_SPAWN_EGG, EnvironmentalItems.ZORSE_SPAWN_EGG, EnvironmentalItems.ZONKEY_SPAWN_EGG, EnvironmentalItems.PINECONE_GOLEM_SPAWN_EGG});
        this.koiBuckets();
        this.getBuilder(EnvironmentalItemModelProvider.name((ItemLike)((ItemLike)EnvironmentalItems.SLABFISH_BUCKET.get())));
        Arrays.stream(EnvironmentalSlabfishTypes.class.getDeclaredFields()).forEach(field -> {
            if (Modifier.isStatic(field.getModifiers()) && ResourceKey.class.isAssignableFrom(field.getType())) {
                try {
                    ResourceLocation location = ((ResourceKey)field.get(null)).m_135782_().m_247266_(s -> "item/slabfish_bucket/" + s);
                    ((ItemModelBuilder)this.withExistingParent(location.m_135815_(), "item/generated")).texture("layer0", location);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void koiBuckets() {
        String path = ForgeRegistries.ITEMS.getKey((Object)((Item)EnvironmentalItems.KOI_BUCKET.get())).m_135815_();
        ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(path, "item/generated")).texture("layer0", new ResourceLocation(this.modid, "item/" + path + "/" + KoiBreed.KOHAKU.name().toLowerCase(Locale.ROOT)));
        for (KoiBreed breed : KoiBreed.values()) {
            ResourceLocation name = new ResourceLocation(this.modid, "item/" + path + "/" + breed.name().toLowerCase(Locale.ROOT));
            model.override().model((ModelFile)new ModelFile.UncheckedModelFile(name)).predicate(new ResourceLocation(this.modid, "variant"), (float)breed.getId());
            ((ItemModelBuilder)this.withExistingParent(name.m_135815_(), "item/generated")).texture("layer0", name);
        }
    }
}

