/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;

public class ShortBambooFeature
extends Feature<ProbabilityFeatureConfiguration> {
    private static final BlockState BAMBOO_TRUNK = (BlockState)((BlockState)((BlockState)Blocks.f_50571_.m_49966_().m_61124_((Property)BambooStalkBlock.f_260603_, (Comparable)Integer.valueOf(1))).m_61124_((Property)BambooStalkBlock.f_260716_, (Comparable)BambooLeaves.NONE)).m_61124_((Property)BambooStalkBlock.f_260694_, (Comparable)Integer.valueOf(0));
    private static final BlockState BAMBOO_FINAL_LARGE = (BlockState)((BlockState)BAMBOO_TRUNK.m_61124_((Property)BambooStalkBlock.f_260716_, (Comparable)BambooLeaves.LARGE)).m_61124_((Property)BambooStalkBlock.f_260694_, (Comparable)Integer.valueOf(1));
    private static final BlockState BAMBOO_TOP_LARGE = (BlockState)BAMBOO_TRUNK.m_61124_((Property)BambooStalkBlock.f_260716_, (Comparable)BambooLeaves.LARGE);
    private static final BlockState BAMBOO_TOP_SMALL = (BlockState)BAMBOO_TRUNK.m_61124_((Property)BambooStalkBlock.f_260716_, (Comparable)BambooLeaves.SMALL);

    public ShortBambooFeature(Codec<ProbabilityFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ProbabilityFeatureConfiguration> config) {
        int count = 0;
        BlockPos origin = config.m_159777_();
        WorldGenLevel level = config.m_159774_();
        RandomSource random = config.m_225041_();
        ProbabilityFeatureConfiguration probabilityfeatureconfiguration = (ProbabilityFeatureConfiguration)config.m_159778_();
        BlockPos.MutableBlockPos bambooPos = origin.m_122032_();
        BlockPos.MutableBlockPos podzolPos = origin.m_122032_();
        if (level.m_46859_((BlockPos)bambooPos)) {
            if (Blocks.f_50571_.m_49966_().m_60710_((LevelReader)level, (BlockPos)bambooPos)) {
                int bambooHeight = random.m_188503_(7) + 5;
                if (random.m_188501_() < probabilityfeatureconfiguration.f_67859_) {
                    int podzolRadius = random.m_188503_(4) + 1;
                    for (int xPos = origin.m_123341_() - podzolRadius; xPos <= origin.m_123341_() + podzolRadius; ++xPos) {
                        for (int zPos = origin.m_123343_() - podzolRadius; zPos <= origin.m_123343_() + podzolRadius; ++zPos) {
                            int zDist;
                            int xDist = xPos - origin.m_123341_();
                            if (xDist * xDist + (zDist = zPos - origin.m_123343_()) * zDist > podzolRadius * podzolRadius) continue;
                            podzolPos.m_122178_(xPos, level.m_6924_(Heightmap.Types.WORLD_SURFACE, xPos, zPos) - 1, zPos);
                            if (!ShortBambooFeature.m_159759_((BlockState)level.m_8055_((BlockPos)podzolPos))) continue;
                            level.m_7731_((BlockPos)podzolPos, Blocks.f_50599_.m_49966_(), 2);
                            if (!level.m_8055_(podzolPos.m_7494_()).m_60795_() || !random.m_188499_()) continue;
                            level.m_7731_(podzolPos.m_7494_(), Blocks.f_50034_.m_49966_(), 2);
                        }
                    }
                }
                for (int i = 0; i < bambooHeight && level.m_46859_((BlockPos)bambooPos); ++i) {
                    level.m_7731_((BlockPos)bambooPos, BAMBOO_TRUNK, 2);
                    bambooPos.m_122175_(Direction.UP, 1);
                }
                if (bambooPos.m_123342_() - origin.m_123342_() >= 3) {
                    level.m_7731_((BlockPos)bambooPos, BAMBOO_FINAL_LARGE, 2);
                    level.m_7731_((BlockPos)bambooPos.m_122175_(Direction.DOWN, 1), BAMBOO_TOP_LARGE, 2);
                    level.m_7731_((BlockPos)bambooPos.m_122175_(Direction.DOWN, 1), BAMBOO_TOP_SMALL, 2);
                }
            }
            ++count;
        }
        return count > 0;
    }
}

