/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.levelgen.feature.configurations.BestNoisesSelectorFeatureConfiguration;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class BestNoisesSelectorFeature
extends Feature<BestNoisesSelectorFeatureConfiguration> {
    public BestNoisesSelectorFeature(Codec<BestNoisesSelectorFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<BestNoisesSelectorFeatureConfiguration> context) {
        BestNoisesSelectorFeatureConfiguration config = (BestNoisesSelectorFeatureConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        ChunkGenerator chunkgenerator = context.m_159775_();
        BlockPos origin = context.m_159777_();
        NormalNoise[] noises = config.getNoises(level);
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < noises.length; ++i) {
            values.add(Pair.of((Object)i, (Object)noises[i].m_75380_((double)origin.m_123341_(), (double)origin.m_123342_(), (double)origin.m_123343_())));
        }
        values.sort(Comparator.comparingDouble(pair -> -((Double)pair.getSecond()).doubleValue()));
        if ((double)config.blending <= 0.0) {
            return ((PlacedFeature)config.features.get((Integer)((Pair)values.get(0)).getFirst()).m_203334_()).m_226357_(level, chunkgenerator, random, origin);
        }
        double bestvalue = (Double)((Pair)values.get(0)).getSecond();
        double blendthreshold = bestvalue - (double)config.blending;
        DoubleArrayList validvalues = new DoubleArrayList();
        for (int i = 0; i < noises.length; ++i) {
            double d0 = ((Double)((Pair)values.get(i)).getSecond() - blendthreshold) / (double)config.blending;
            if (!(d0 >= 0.0)) continue;
            validvalues.add(d0);
        }
        int validcount = validvalues.size();
        int featureindex = validcount - 1;
        double sum = validvalues.doubleStream().sum();
        double randomvalue = random.m_188500_();
        for (int i = 0; i < validcount; ++i) {
            double d0 = validvalues.getDouble(i) / sum;
            if (randomvalue < d0) {
                featureindex = i;
                break;
            }
            randomvalue -= d0;
        }
        return ((PlacedFeature)config.features.get((Integer)((Pair)values.get(featureindex)).getFirst()).m_203334_()).m_226357_(level, chunkgenerator, random, origin);
    }
}

