/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal;

import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.other.tags.BlueprintItemTags;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.other.EnvironmentalDataProcessors;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBiomeTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="environmental")
public class MuddyPig {
    public static final int MAX_DRYING_TIME = 36000;

    public static boolean enabled() {
        return (Boolean)EnvironmentalConfig.COMMON.muddyPigs.get();
    }

    public static boolean isMuddy(Pig pig) {
        IDataManager data = (IDataManager)pig;
        return (Boolean)data.getValue(EnvironmentalDataProcessors.IS_MUDDY);
    }

    public static int getDryingTime(Pig pig) {
        IDataManager data = (IDataManager)pig;
        return (Integer)data.getValue(EnvironmentalDataProcessors.MUD_DRYING_TIME);
    }

    public static void setMuddy(Pig pig, boolean muddy) {
        IDataManager data = (IDataManager)pig;
        data.setValue(EnvironmentalDataProcessors.IS_MUDDY, (Object)muddy);
    }

    public static void setDryingTime(Pig pig, int amount) {
        IDataManager data = (IDataManager)pig;
        data.setValue(EnvironmentalDataProcessors.MUD_DRYING_TIME, (Object)amount);
    }

    public static void updateDryingTime(Pig pig, int amount) {
        MuddyPig.setDryingTime(pig, Mth.m_14045_((int)0, (int)(MuddyPig.getDryingTime(pig) + amount), (int)36000));
    }

    public static boolean canGetWet(Pig pig) {
        return pig.m_20072_() && (Boolean)EnvironmentalConfig.COMMON.muddyPigsGetWetInWater.get() != false || pig.m_20070_() && !pig.m_20069_() && (Boolean)EnvironmentalConfig.COMMON.muddyPigsGetWetInRain.get() != false;
    }

    public static void removeDecoration(Pig pig) {
        IDataManager data = (IDataManager)pig;
        data.setValue(EnvironmentalDataProcessors.MUDDY_PIG_DECORATION, (Object)new ResourceLocation("empty"));
    }

    public static boolean isDry(Pig pig) {
        return MuddyPig.getDryingTime(pig) < 60;
    }

    public static Optional<Item> getDecoration(Pig pig) {
        ResourceLocation decoration;
        Item item;
        IDataManager data = (IDataManager)pig;
        if (MuddyPig.isMuddy(pig) && (item = (Item)ForgeRegistries.ITEMS.getValue(decoration = (ResourceLocation)data.getValue(EnvironmentalDataProcessors.MUDDY_PIG_DECORATION))) instanceof BlockItem) {
            return Optional.of(item);
        }
        return Optional.empty();
    }

    @SubscribeEvent
    public static void onLivingSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        ServerLevelAccessor level = event.getLevel();
        if (event.getResult() != Event.Result.DENY) {
            RandomSource random = level.m_213780_();
            if (entity instanceof Pig) {
                Pig pig = (Pig)entity;
                if (MuddyPig.enabled() && ((Boolean)EnvironmentalConfig.COMMON.naturalMuddyPigs.get()).booleanValue() && level.m_204166_(entity.m_20183_()).m_203656_(EnvironmentalBiomeTags.HAS_MUDDY_PIG)) {
                    IDataManager data = (IDataManager)entity;
                    MuddyPig.setMuddy(pig, true);
                    MuddyPig.setDryingTime(pig, 36000);
                    if ((double)random.m_188501_() < (Double)EnvironmentalConfig.COMMON.muddyPigDecorationChance.get()) {
                        Optional item = ForgeRegistries.ITEMS.tags().getTag(EnvironmentalItemTags.SPAWNS_ON_MUDDY_PIG).getRandomElement(random);
                        item.ifPresent(value -> data.setValue(EnvironmentalDataProcessors.MUDDY_PIG_DECORATION, (Object)ForgeRegistries.ITEMS.getKey(value)));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_20193_();
        if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            if (entity.m_6084_() && MuddyPig.isMuddy(pig)) {
                int mudDryingTime = MuddyPig.getDryingTime(pig);
                if (MuddyPig.canGetWet(pig)) {
                    MuddyPig.updateDryingTime(pig, 1);
                } else if (((Boolean)EnvironmentalConfig.COMMON.muddyPigsDryOverTime.get()).booleanValue() && (!((Boolean)EnvironmentalConfig.COMMON.muddyPigsOnlyDryInTheNether.get()).booleanValue() || level.m_6042_().f_63857_())) {
                    MuddyPig.updateDryingTime(pig, -1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        Level level = event.getLevel();
        RandomSource random = level.m_213780_();
        if (target instanceof Pig) {
            Pig pig = (Pig)target;
            if (target.m_6084_()) {
                IDataManager data = (IDataManager)target;
                if (MuddyPig.enabled() && MuddyPig.isMuddy(pig)) {
                    ItemEntity item;
                    boolean allowDecorating;
                    boolean dried = MuddyPig.getDryingTime(pig) <= 0;
                    Optional<Item> decoration = MuddyPig.getDecoration(pig);
                    if (decoration.isEmpty()) {
                        MuddyPig.removeDecoration(pig);
                    }
                    if (allowDecorating = ((Boolean)EnvironmentalConfig.COMMON.decoratableMuddyPigs.get()).booleanValue()) {
                        if (decoration.isEmpty()) {
                            if (stack.m_204117_(EnvironmentalItemTags.MUDDY_PIG_DECORATIONS)) {
                                data.setValue(EnvironmentalDataProcessors.MUDDY_PIG_DECORATION, (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
                                level.m_6269_(null, target, dried ? SoundEvents.f_215727_ : SoundEvents.f_215711_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                if (!event.getEntity().m_7500_()) {
                                    stack.m_41774_(1);
                                }
                                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                                event.setCanceled(true);
                            }
                        } else if (stack.canPerformAction(ToolActions.SHEARS_CARVE)) {
                            level.m_6269_(null, target, SoundEvents.f_12480_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            target.m_146852_(GameEvent.f_157781_, (Entity)player);
                            if (!level.m_5776_()) {
                                item = target.m_5552_(new ItemStack((ItemLike)decoration.get()), 1.0f);
                                item.m_20256_(item.m_20184_().m_82520_((double)((random.m_188501_() - random.m_188501_()) * 0.1f), (double)(random.m_188501_() * 0.05f), (double)((random.m_188501_() - random.m_188501_()) * 0.1f)));
                                stack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(hand));
                            }
                            MuddyPig.removeDecoration(pig);
                            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                            event.setCanceled(true);
                        }
                    }
                    if (stack.m_204117_(EnvironmentalItemTags.MUDDY_PIG_DRYING_ITEMS) && !dried && !MuddyPig.canGetWet(pig) && !pig.m_20075_().m_60713_(Blocks.f_220864_)) {
                        level.m_6269_(null, target, SoundEvents.f_215727_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!event.getEntity().m_7500_()) {
                            stack.m_41774_(1);
                        }
                        MuddyPig.setDryingTime(pig, 0);
                        event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                        event.setCanceled(true);
                    } else if (stack.m_204117_(BlueprintItemTags.BUCKETS_WATER)) {
                        level.m_6269_(null, target, SoundEvents.f_11917_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)stack.getCraftingRemainingItem()));
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                        if (!level.f_46443_) {
                            ServerLevel serverlevel = (ServerLevel)level;
                            for (int i = 0; i < 5; ++i) {
                                serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, target.m_20185_() + level.f_46441_.m_188500_(), target.m_20186_() + 1.0, target.m_20189_() + level.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 1.0);
                            }
                        }
                        MuddyPig.setMuddy(pig, false);
                        MuddyPig.setDryingTime(pig, 0);
                        if (decoration.isPresent()) {
                            if (!level.m_5776_()) {
                                item = target.m_5552_(new ItemStack((ItemLike)decoration.get()), 1.0f);
                                item.m_20256_(item.m_20184_().m_82520_((double)((random.m_188501_() - random.m_188501_()) * 0.1f), (double)(random.m_188501_() * 0.05f), (double)((random.m_188501_() - random.m_188501_()) * 0.1f)));
                                stack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(hand));
                            }
                            MuddyPig.removeDecoration(pig);
                        }
                        level.m_6269_(null, target, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Pig pig;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Pig && MuddyPig.getDecoration(pig = (Pig)entity).isPresent()) {
            pig.m_19998_((ItemLike)MuddyPig.getDecoration(pig).get());
        }
    }
}

