/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class HerdWanderGoal
extends RandomStrollGoal {
    protected Predicate<PathfinderMob> herdPredicate = this.defaultHerdPredicate();
    protected double speedModifierFar;
    protected int preferredHerdSize;
    protected boolean isHerdFar;

    public HerdWanderGoal(PathfinderMob mob, double speed, double speedFar, int herdSize) {
        super(mob, speed);
        this.speedModifierFar = speedFar;
        this.preferredHerdSize = herdSize;
    }

    public HerdWanderGoal(PathfinderMob mob, double speed, double speedFar, int interval, int herdSize) {
        super(mob, speed, interval);
        this.speedModifierFar = speedFar;
        this.preferredHerdSize = herdSize;
    }

    public HerdWanderGoal(PathfinderMob mob, double speed, double speedFar, int interval, boolean checkNoActionTime, int herdSize) {
        super(mob, speed, interval, checkNoActionTime);
        this.speedModifierFar = speedFar;
        this.preferredHerdSize = herdSize;
    }

    @Nullable
    protected Vec3 m_7037_() {
        List herd = this.f_25725_.m_9236_().m_6443_(PathfinderMob.class, this.f_25725_.m_20191_().m_82377_(32.0, 8.0, 32.0), this.herdPredicate.and(entity -> entity != this.f_25725_));
        List<PathfinderMob> closeherd = herd.stream().sorted(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)this.f_25725_))).limit(this.preferredHerdSize - 1).toList();
        if (!closeherd.isEmpty()) {
            PathfinderMob entity2;
            int herdsize;
            double frienddist = this.f_25725_.m_20280_((Entity)closeherd.get(0));
            double herdx = 0.0;
            double herdy = 0.0;
            double herdz = 0.0;
            Iterator<PathfinderMob> iterator = closeherd.iterator();
            for (herdsize = 0; iterator.hasNext() && (!(this.f_25725_.m_20280_((Entity)(entity2 = iterator.next())) > 144.0) || herdsize < this.preferredHerdSize - 2); ++herdsize) {
                herdx += entity2.m_20185_();
                herdy += entity2.m_20186_();
                herdz += entity2.m_20189_();
            }
            Vec3 herdcenter = new Vec3(herdx / (double)herdsize, herdy / (double)herdsize, herdz / (double)herdsize);
            if (herdsize > 0) {
                double herddist = this.f_25725_.m_20238_(herdcenter);
                if (frienddist > 9.0 || herddist > 64.0) {
                    int maxdist = Math.min(Math.max(Mth.m_14107_((double)Math.sqrt(herddist)), 3), 16);
                    int mindist = Math.max(maxdist - 4, 1);
                    for (int i = 0; i < 8; ++i) {
                        Vec3 pos = DefaultRandomPos.m_148412_((PathfinderMob)this.f_25725_, (int)maxdist, (int)mindist, (Vec3)herdcenter, (double)1.5707963267948966);
                        if (pos == null) continue;
                        this.isHerdFar = herddist > 196.0;
                        return pos;
                    }
                }
            }
        }
        return this.randomPosition();
    }

    public void m_8056_() {
        this.f_25725_.m_21573_().m_26519_(this.f_25726_, this.f_25727_, this.f_25728_, this.isHerdFar ? this.speedModifierFar : this.f_25729_);
    }

    public HerdWanderGoal setHerdPredicate(Predicate<PathfinderMob> predicate) {
        this.herdPredicate = predicate;
        return this;
    }

    protected Predicate<PathfinderMob> defaultHerdPredicate() {
        return entity -> entity.getClass().isAssignableFrom(this.f_25725_.getClass()) || this.f_25725_.getClass().isAssignableFrom(entity.getClass());
    }

    protected Vec3 randomPosition() {
        return DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)10, (int)7);
    }
}

