/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class GiantLilyPadBlock
extends BushBlock
implements IPlantable {
    protected static final VoxelShape GIANT_LILY_PAD_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.2001, (double)16.0);
    public static final EnumProperty<LilyPadPosition> POSITION = EnumProperty.m_61587_((String)"position", LilyPadPosition.class);

    public GiantLilyPadBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POSITION});
    }

    public static void placeAt(Level world, BlockPos pos, BlockState state, int flags) {
        world.m_7731_(pos, (BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.CENTER)), flags);
        world.m_7731_(pos.m_121945_(Direction.NORTH), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.NORTH)), flags);
        world.m_7731_(pos.m_121945_(Direction.EAST), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.EAST)), flags);
        world.m_7731_(pos.m_121945_(Direction.SOUTH), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.SOUTH)), flags);
        world.m_7731_(pos.m_121945_(Direction.WEST), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.WEST)), flags);
        world.m_7731_(pos.m_121945_(Direction.NORTH).m_121945_(Direction.EAST), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.NORTHEAST)), flags);
        world.m_7731_(pos.m_121945_(Direction.SOUTH).m_121945_(Direction.EAST), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.SOUTHEAST)), flags);
        world.m_7731_(pos.m_121945_(Direction.SOUTH).m_121945_(Direction.WEST), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.SOUTHWEST)), flags);
        world.m_7731_(pos.m_121945_(Direction.NORTH).m_121945_(Direction.WEST), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.NORTHWEST)), flags);
    }

    public static boolean checkPositions(Level world, BlockPos pos, BlockState state) {
        if (!GiantLilyPadBlock.isValidPosAndAir((BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.NORTH)), world, pos.m_121945_(Direction.NORTH))) {
            return false;
        }
        if (!GiantLilyPadBlock.isValidPosAndAir((BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.EAST)), world, pos.m_121945_(Direction.EAST))) {
            return false;
        }
        if (!GiantLilyPadBlock.isValidPosAndAir((BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.SOUTH)), world, pos.m_121945_(Direction.SOUTH))) {
            return false;
        }
        if (!GiantLilyPadBlock.isValidPosAndAir((BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.WEST)), world, pos.m_121945_(Direction.WEST))) {
            return false;
        }
        if (!GiantLilyPadBlock.isValidPosAndAir((BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.NORTHEAST)), world, GiantLilyPadBlock.posToBlockPos(LilyPadPosition.NORTHEAST, pos, false))) {
            return false;
        }
        if (!GiantLilyPadBlock.isValidPosAndAir((BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.SOUTHEAST)), world, pos.m_121945_(Direction.SOUTH).m_121945_(Direction.EAST))) {
            return false;
        }
        if (!GiantLilyPadBlock.isValidPosAndAir((BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.SOUTHWEST)), world, pos.m_121945_(Direction.SOUTH).m_121945_(Direction.WEST))) {
            return false;
        }
        return GiantLilyPadBlock.isValidPosAndAir((BlockState)state.m_61124_(POSITION, (Comparable)((Object)LilyPadPosition.NORTHWEST)), world, pos.m_121945_(Direction.NORTH).m_121945_(Direction.WEST));
    }

    public static boolean isValidPosAndAir(BlockState state, Level world, BlockPos pos) {
        return state.m_60710_((LevelReader)world, pos) && world.m_8055_(pos).m_60795_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return GIANT_LILY_PAD_AABB;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.m_142072_(level, state, pos, entity, 0.0f);
    }

    public void m_5548_(BlockGetter level, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(level, entity);
        } else {
            this.bounce(entity);
        }
    }

    private void bounce(Entity entity) {
        Vec3 vector3d = entity.m_20184_();
        if (vector3d.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.4 : 1.0;
            entity.m_20334_(vector3d.f_82479_, -vector3d.f_82480_ * d0, vector3d.f_82481_);
            if (vector3d.f_82480_ < -0.1) {
                Player player;
                entity.m_9236_().m_6263_(entity instanceof Player ? (player = (Player)entity) : null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)EnvironmentalSoundEvents.GIANT_LILY_PAD_BOUNCE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_((BlockGetter)level, entity);
        } else {
            this.bounce(entity);
        }
    }

    public boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return GiantLilyPadBlock.isValidBlock(state, level, pos);
    }

    public static boolean isValidBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return (level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_) || state.m_60734_() instanceof IceBlock) && level.m_6425_(pos.m_7494_()).m_192917_(Fluids.f_76191_);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        if (state.m_60734_() == this) {
            return worldIn.m_8055_(blockpos).canSustainPlant((BlockGetter)worldIn, blockpos, Direction.UP, (IPlantable)this);
        }
        return this.m_6266_(worldIn.m_8055_(blockpos), (BlockGetter)worldIn, blockpos);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) || !this.isConnected(stateIn, (BlockGetter)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean isConnected(BlockState state, BlockGetter worldIn, BlockPos pos) {
        LilyPadPosition position = (LilyPadPosition)((Object)state.m_61143_(POSITION));
        pos = GiantLilyPadBlock.posToBlockPos(position, pos, true);
        for (LilyPadPosition newPosition : LilyPadPosition.values()) {
            if (worldIn.m_8055_(GiantLilyPadBlock.posToBlockPos(newPosition, pos, false)).m_60713_((Block)this) && worldIn.m_8055_(GiantLilyPadBlock.posToBlockPos(newPosition, pos, false)).m_61143_(POSITION) == newPosition) continue;
            return false;
        }
        return true;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_) {
            if (player.m_7500_()) {
                GiantLilyPadBlock.removeEachBlock(worldIn, pos, state, player);
            } else {
                GiantLilyPadBlock.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    private static void removeEachBlock(Level world, BlockPos pos, BlockState state, Player player) {
        LilyPadPosition position = (LilyPadPosition)((Object)state.m_61143_(POSITION));
        pos = GiantLilyPadBlock.posToBlockPos(position, pos, true);
        for (LilyPadPosition lilyPadPos : LilyPadPosition.values()) {
            GiantLilyPadBlock.removeBlock(lilyPadPos, world, pos, state, player);
        }
    }

    private static void removeBlock(LilyPadPosition position, Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos = GiantLilyPadBlock.posToBlockPos(position, pos, false);
        BlockState blockstate = world.m_8055_(blockpos);
        if (blockstate.m_60734_() == state.m_60734_() && blockstate.m_61143_(POSITION) == position) {
            world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 51);
            world.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, Blocks.f_50016_.m_49966_(), te, stack);
    }

    public static BlockPos posToBlockPos(LilyPadPosition position, BlockPos pos, boolean revert) {
        if (!revert) {
            return switch (position) {
                default -> throw new IncompatibleClassChangeError();
                case LilyPadPosition.NORTH -> pos.m_121945_(Direction.NORTH);
                case LilyPadPosition.EAST -> pos.m_121945_(Direction.EAST);
                case LilyPadPosition.SOUTH -> pos.m_121945_(Direction.SOUTH);
                case LilyPadPosition.WEST -> pos.m_121945_(Direction.WEST);
                case LilyPadPosition.NORTHEAST -> pos.m_121945_(Direction.NORTH).m_121945_(Direction.EAST);
                case LilyPadPosition.NORTHWEST -> pos.m_121945_(Direction.NORTH).m_121945_(Direction.WEST);
                case LilyPadPosition.SOUTHEAST -> pos.m_121945_(Direction.SOUTH).m_121945_(Direction.EAST);
                case LilyPadPosition.SOUTHWEST -> pos.m_121945_(Direction.SOUTH).m_121945_(Direction.WEST);
                case LilyPadPosition.CENTER -> pos;
            };
        }
        return switch (position) {
            default -> throw new IncompatibleClassChangeError();
            case LilyPadPosition.NORTH -> pos.m_121945_(Direction.SOUTH);
            case LilyPadPosition.EAST -> pos.m_121945_(Direction.WEST);
            case LilyPadPosition.SOUTH -> pos.m_121945_(Direction.NORTH);
            case LilyPadPosition.WEST -> pos.m_121945_(Direction.EAST);
            case LilyPadPosition.NORTHEAST -> pos.m_121945_(Direction.SOUTH).m_121945_(Direction.WEST);
            case LilyPadPosition.NORTHWEST -> pos.m_121945_(Direction.SOUTH).m_121945_(Direction.EAST);
            case LilyPadPosition.SOUTHEAST -> pos.m_121945_(Direction.NORTH).m_121945_(Direction.WEST);
            case LilyPadPosition.SOUTHWEST -> pos.m_121945_(Direction.NORTH).m_121945_(Direction.EAST);
            case LilyPadPosition.CENTER -> pos;
        };
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.WATER;
    }

    public static enum LilyPadPosition implements StringRepresentable
    {
        CENTER("center"),
        NORTH("north"),
        NORTHEAST("northeast"),
        EAST("east"),
        SOUTHEAST("southeast"),
        SOUTH("south"),
        SOUTHWEST("southwest"),
        WEST("west"),
        NORTHWEST("northwest");

        private final String heightName;

        private LilyPadPosition(String nameIn) {
            this.heightName = nameIn;
        }

        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return this.heightName;
        }
    }
}

