/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.google.common.collect.Maps;
import com.teamabnormals.environmental.common.block.DwarfSpruceBlock;
import com.teamabnormals.environmental.common.block.DwarfSprucePlantBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;

public class DwarfSpruceHeadBlock
extends DwarfSpruceBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty STAR = BooleanProperty.m_61465_((String)"star");
    private static final Map<Supplier<? extends Item>, Block> TORCH_SPRUCES = Maps.newHashMap();
    protected DwarfSprucePlantBlock bodyBlock;

    public DwarfSpruceHeadBlock(BlockBehaviour.Properties properties) {
        this(properties, (Supplier<Item>)null);
    }

    public DwarfSpruceHeadBlock(BlockBehaviour.Properties properties, ResourceLocation torch) {
        this(properties, () -> (Item)ForgeRegistries.ITEMS.getValue(torch));
    }

    public DwarfSpruceHeadBlock(BlockBehaviour.Properties properties, Supplier<Item> torch) {
        super(properties, torch);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STAR, (Comparable)Boolean.valueOf(false)));
    }

    public void setBodyBlock(DwarfSprucePlantBlock block) {
        this.bodyBlock = block;
    }

    @Override
    public Item getTorch() {
        return this.torch == null || this.torch.get() == Items.f_41852_ ? null : (Item)this.torch.get();
    }

    @Override
    public Map<Supplier<? extends Item>, Block> getTorchSpruces() {
        return TORCH_SPRUCES;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        int light = state.m_60791_();
        return (Boolean)state.m_61143_((Property)STAR) != false && light < 10 ? 10 : light;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState belowstate = level.m_8055_(pos.m_7495_());
        boolean flag = belowstate.m_60734_() instanceof DwarfSpruceHeadBlock;
        if (DwarfSpruceHeadBlock.isValidAboveBlock(level.m_8055_(pos.m_7494_()))) {
            return (BlockState)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT.get()).m_49966_().m_61124_((Property)DwarfSprucePlantBlock.BOTTOM, (Comparable)Boolean.valueOf(!flag));
        }
        if (flag) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)STAR, (Comparable)((Boolean)belowstate.m_61143_((Property)STAR)));
        }
        return this.m_49966_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        return direction == Direction.UP && DwarfSpruceHeadBlock.isValidAboveBlock(offsetState) ? this.getBodyState(state) : state;
    }

    protected BlockState getBodyState(BlockState originalState) {
        return (BlockState)this.bodyBlock.m_49966_().m_61124_((Property)DwarfSprucePlantBlock.BOTTOM, (Comparable)Boolean.valueOf((Boolean)originalState.m_61143_((Property)TOP) == false));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (itemstack.canPerformAction(ToolActions.SHEARS_HARVEST) && ((Boolean)state.m_61143_((Property)STAR)).booleanValue()) {
            DwarfSpruceHeadBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42686_));
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)STAR, (Comparable)Boolean.valueOf(false)));
            itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
            level.m_5594_(null, pos, SoundEvents.f_12480_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!((Boolean)state.m_61143_((Property)STAR)).booleanValue() && item == Items.f_42686_) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)STAR, (Comparable)Boolean.valueOf(true)));
            level.m_5594_(null, pos, SoundEvents.f_144057_, SoundSource.BLOCKS, 0.4f, 1.0f);
            level.m_5594_(null, pos, SoundEvents.f_144053_, SoundSource.BLOCKS, 0.8f, 1.0f);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    @Override
    public BlockState getWithoutTorchesState(BlockState state) {
        return (BlockState)((BlockState)((Block)EnvironmentalBlocks.DWARF_SPRUCE.get()).m_49966_().m_61124_((Property)TOP, (Comparable)((Boolean)state.m_61143_((Property)TOP)))).m_61124_((Property)STAR, (Comparable)((Boolean)state.m_61143_((Property)STAR)));
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return level.m_8055_(pos.m_7494_()).m_60795_();
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)((Block)EnvironmentalBlocks.DWARF_SPRUCE.get()).m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)STAR, (Comparable)((Boolean)state.m_61143_((Property)STAR))));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TOP, STAR});
    }
}

