/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.storage.tracking;

import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public interface IDataManager {
    public <T> void setValue(TrackedData<T> var1, T var2);

    public <T> T getValue(TrackedData<T> var1);

    public boolean isDirty();

    public void clean();

    public Map<TrackedData<?>, DataEntry<?>> getDataMap();

    public void setDataMap(Map<TrackedData<?>, DataEntry<?>> var1);

    public Set<DataEntry<?>> getDirtyEntries();

    public Set<DataEntry<?>> getEntries(boolean var1);

    public static class DataEntry<T> {
        private final TrackedData<T> trackedData;
        private T value;
        private boolean dirty;

        public DataEntry(TrackedData<T> trackedData) {
            this.trackedData = trackedData;
            this.value = trackedData.getDefaultValue();
        }

        public static DataEntry<?> read(FriendlyByteBuf buffer) {
            int id = buffer.m_130242_();
            TrackedData<?> trackedData = TrackedDataManager.INSTANCE.getTrackedData(id);
            Objects.requireNonNull(trackedData, String.format("Tracked Data does not exist for id %o", id));
            DataEntry entry = new DataEntry(trackedData);
            entry.readValue(buffer.m_130260_(), true);
            return entry;
        }

        public TrackedData<T> getTrackedData() {
            return this.trackedData;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value, boolean dirty) {
            this.value = value;
            this.dirty = dirty;
        }

        public void markDirty() {
            this.dirty = true;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void clean() {
            this.dirty = false;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130130_(TrackedDataManager.INSTANCE.getId(this.trackedData));
            buffer.m_130079_(this.writeValue());
        }

        public CompoundTag writeValue() {
            return this.getTrackedData().getProcessor().write(this.value);
        }

        public void readValue(CompoundTag compound, boolean dirty) {
            this.value = this.getTrackedData().getProcessor().read(compound);
            this.dirty = dirty;
        }
    }
}

