/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client.list;

import com.epherical.serverbrowser.client.CommonClient;
import com.epherical.serverbrowser.client.screen.ServerBrowserScreen;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ServerBrowserList
extends ObjectSelectionList<Entry> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("ServerBrowser Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    private static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/server_selection.png");
    private static final Component CANT_RESOLVE_TEXT = Component.m_237115_((String)"multiplayer.status.cannot_resolve").m_130940_(ChatFormatting.DARK_RED);
    private static final Component CANT_CONNECT_TEXT = Component.m_237115_((String)"multiplayer.status.cannot_connect").m_130940_(ChatFormatting.DARK_RED);
    private static final Component INCOMPATIBLE_TOOLTIP = Component.m_237115_((String)"multiplayer.status.incompatible");
    private static final Component NO_CONNECTION_TOOLTIP = Component.m_237115_((String)"multiplayer.status.no_connection");
    private static final Component PINGING_TOOLTIP = Component.m_237115_((String)"multiplayer.status.pinging");
    static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private final ServerBrowserScreen screen;
    private final List<BrowsedEntry> entries = new ArrayList<BrowsedEntry>();

    public ServerBrowserList(ServerBrowserScreen screen, Minecraft minecraft, int i, int j, int k, int l, int m) {
        super(minecraft, i, j, k, l, m);
        this.screen = screen;
    }

    public void refreshServers() {
        for (BrowsedEntry entry : this.entries) {
            entry.getServerData().f_105369_ = false;
        }
    }

    public List<BrowsedEntry> getEntries() {
        return this.entries;
    }

    public void queryServers() {
        this.entries.clear();
        this.m_93516_();
    }

    public void addEntries(JsonElement jsonElement, boolean toTop) {
        JsonArray array = new JsonArray();
        array = jsonElement.getAsJsonArray();
        for (JsonElement element : array) {
            JsonObject object = (JsonObject)element;
            BrowsedEntry browsedEntry = toTop ? new BrowsedEntry(this.screen, object.get("name").getAsString(), object.get("ip").getAsString(), object.get("port").getAsInt(), this.f_93386_) : new BrowsedEntry(this.screen, object, this.f_93386_);
            if (!browsedEntry.isValid()) continue;
            this.entries.add(browsedEntry);
            if (toTop) {
                this.m_239857_((AbstractSelectionList.Entry)browsedEntry);
                continue;
            }
            this.m_7085_((AbstractSelectionList.Entry)browsedEntry);
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 30;
    }

    public int m_5759_() {
        return super.m_5759_() + 85;
    }

    public class BrowsedEntry
    extends Entry {
        private final ServerBrowserScreen screen;
        private final String serverName;
        private final String ipAddress;
        private final int port;
        private final Component description;
        private final List<String> tags;
        private final int rank;
        private final int bgColor;
        @Nullable
        private byte[] lastIconB64;
        private FaviconTexture icon;
        private final Minecraft minecraft;
        private ServerData serverData;
        private long lastClickTime;
        private boolean valid = true;
        private AtomicBoolean validServer = new AtomicBoolean(true);

        public BrowsedEntry(ServerBrowserScreen screen, String serverName, String ipAddress, int port, Minecraft minecraft) {
            this.screen = screen;
            int strLen = serverName.length();
            this.serverName = strLen <= 45 ? serverName : serverName.substring(0, 45);
            this.ipAddress = ipAddress;
            this.port = port;
            this.description = Component.m_237113_((String)"Unknown server from 3rd party service.");
            this.rank = 0;
            this.bgColor = 2188223;
            this.minecraft = minecraft;
            this.tags = new ArrayList<String>();
            this.assignCommonData();
        }

        public BrowsedEntry(ServerBrowserScreen screen, JsonObject object, Minecraft minecraft) {
            this.screen = screen;
            String serverName = object.get("serverName").getAsString();
            int strLen = serverName.length();
            this.serverName = strLen <= 40 ? serverName : serverName.substring(0, 40);
            this.ipAddress = object.get("ipAddress").getAsString();
            this.port = object.get("port").getAsInt();
            String address = this.ipAddress.toLowerCase(Locale.ROOT);
            if (CommonClient.getInstance().getConfig().blacklistedServers.contains(address)) {
                this.valid = false;
            }
            this.description = Component.m_237113_((String)object.get("description").getAsString());
            ArrayList<String> tags = new ArrayList<String>();
            JsonArray array = object.getAsJsonArray("tags");
            for (JsonElement tag : array) {
                tags.add(tag.getAsString());
            }
            this.tags = tags;
            this.rank = object.get("rank").getAsInt();
            this.bgColor = object.get("backgroundColor").getAsInt();
            this.minecraft = minecraft;
            this.assignCommonData();
        }

        private void assignCommonData() {
            Object ip = this.port != 0 ? this.ipAddress + ":" + this.port : this.ipAddress;
            this.icon = FaviconTexture.m_289187_((TextureManager)this.minecraft.m_91097_(), (String)ip);
            this.serverData = new ServerData(this.serverName, (String)ip, false);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            double d = mouseX - (double)ServerBrowserList.this.m_5747_();
            if (d <= 32.0 && d < 32.0 && d > 16.0 && this.canJoin()) {
                this.screen.setSelected(this);
                this.screen.joinSelectedServer();
                return true;
            }
            this.screen.setSelected(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }

        public Component m_142172_() {
            return Component.m_237113_((String)"howdy partner");
        }

        public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            if (!this.serverData.f_105369_) {
                this.serverData.f_105369_ = true;
                this.serverData.f_105366_ = -2L;
                this.serverData.f_105365_ = CommonComponents.f_237098_;
                this.serverData.f_105364_ = CommonComponents.f_237098_;
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.getPinger().pingServer(this.serverData, () -> this.minecraft.execute(() -> {}), this.validServer);
                    }
                    catch (UnknownHostException var2) {
                        this.serverData.f_105366_ = -1L;
                        this.serverData.f_105365_ = CANT_RESOLVE_TEXT;
                        this.validServer.set(false);
                    }
                    catch (Exception var3) {
                        this.serverData.f_105366_ = -1L;
                        this.serverData.f_105365_ = CANT_CONNECT_TEXT;
                        this.validServer.set(false);
                    }
                });
            }
            if (this.validServer.get()) {
                List list2;
                Component component2;
                int latency;
                boolean bl = this.serverData.f_105367_ != SharedConstants.m_183709_().m_132495_();
                graphics.m_280488_(this.minecraft.f_91062_, this.serverData.f_105362_, left + 32 + 3, top + 1, 0xFFFFFF);
                List list = this.minecraft.f_91062_.m_92923_((FormattedText)this.serverData.f_105365_, width - 32 - 2);
                for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                    graphics.m_280648_(this.minecraft.f_91062_, (FormattedCharSequence)list.get(i), left + 32 + 3, top + 12 + 9 * i, 0x808080);
                }
                Component component = bl ? this.serverData.f_105368_.m_6881_().m_130940_(ChatFormatting.RED) : this.serverData.f_105364_;
                int textWidth = this.minecraft.f_91062_.m_92852_((FormattedText)component);
                graphics.m_280430_(this.minecraft.f_91062_, component, left + width - textWidth - 15 - 2, top + 1, 0x808080);
                int k = 0;
                if (bl) {
                    latency = 5;
                    component2 = INCOMPATIBLE_TOOLTIP;
                    list2 = this.serverData.f_105370_;
                } else if (this.serverData.f_105369_ && this.serverData.f_105366_ != -2L) {
                    latency = this.serverData.f_105366_ < 0L ? 5 : (this.serverData.f_105366_ < 150L ? 0 : (this.serverData.f_105366_ < 300L ? 1 : (this.serverData.f_105366_ < 600L ? 2 : (this.serverData.f_105366_ < 1000L ? 3 : 4))));
                    if (this.serverData.f_105366_ < 0L) {
                        component2 = NO_CONNECTION_TOOLTIP;
                        list2 = Collections.emptyList();
                    } else {
                        component2 = Component.m_237110_((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.f_105366_});
                        list2 = this.serverData.f_105370_;
                    }
                } else {
                    k = 1;
                    latency = (int)(Util.m_137550_() / 100L + (long)index * 2L & 7L);
                    if (latency > 4) {
                        latency = 8 - latency;
                    }
                    component2 = PINGING_TOOLTIP;
                    list2 = Collections.emptyList();
                }
                graphics.m_280163_(GUI_ICONS_LOCATION, left + width - 15, top, (float)(k * 10), (float)(176 + latency * 8), 10, 8, 256, 256);
                byte[] abyte = this.serverData.m_271916_();
                if (!Arrays.equals(abyte, this.lastIconB64)) {
                    if (this.uploadServerIcon(abyte)) {
                        this.lastIconB64 = abyte;
                    } else {
                        this.serverData.m_271813_(null);
                    }
                }
                this.drawIcon(graphics, left, top, this.icon.m_289196_());
                int m = mouseX - left;
                int n = mouseY - top;
                if (((Boolean)this.minecraft.f_91066_.m_231828_().m_231551_()).booleanValue() || isMouseOver) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_OVERLAY_LOCATION);
                    graphics.m_280509_(left, top, left + 32, top + 32, -1601138544);
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    int o = mouseX - left;
                    if (this.canJoin()) {
                        int currentLength = 0;
                        int maxLength = 150;
                        ArrayList<String> condensedTags = new ArrayList<String>();
                        condensedTags.add("Tags");
                        StringBuilder condenser = new StringBuilder();
                        this.tags.sort(String::compareTo);
                        for (String tag : this.tags) {
                            if (currentLength >= maxLength) {
                                currentLength = 0;
                                condensedTags.add(condenser.append(",").toString());
                                condenser = new StringBuilder();
                            } else if (condenser.length() == 0) {
                                condenser.append(tag);
                            } else {
                                condenser.append(", ").append(tag);
                            }
                            currentLength += this.minecraft.f_91062_.m_92895_(tag);
                        }
                        condensedTags.add(condenser.toString());
                        List<Component> components = condensedTags.stream().map(Component::m_237113_).collect(Collectors.toList());
                        this.screen.setToolTip(components);
                    }
                }
                if (m >= width - 15 && m <= width - 5 && n >= 0 && n <= 8) {
                    this.screen.setToolTip(Collections.singletonList(component2));
                } else if (m >= width - textWidth - 15 - 2 && m <= width - 15 - 2 && n >= 0 && n <= 8) {
                    this.screen.setToolTip(list2);
                }
            } else {
                ServerBrowserList.this.m_93502_((AbstractSelectionList.Entry)this);
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        protected void drawIcon(GuiGraphics $$0, int $$1, int $$2, ResourceLocation $$3) {
            RenderSystem.enableBlend();
            $$0.m_280163_($$3, $$1, $$2, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
        }

        private boolean uploadServerIcon(byte[] bytes) {
            if (bytes == null) {
                this.icon.m_289218_();
            } else {
                try {
                    this.icon.m_289201_(NativeImage.m_271751_((byte[])bytes));
                }
                catch (Throwable var3) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.f_105362_, this.serverData.f_105363_, var3});
                    return false;
                }
            }
            return true;
        }

        private boolean canJoin() {
            return true;
        }

        public ServerData getServerData() {
            return this.serverData;
        }
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
    }
}

