/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.endergetic.core.registry.EEPlacementModifierTypes;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class NoiseHeightmap32Placement
extends PlacementModifier {
    public static final Codec<NoiseHeightmap32Placement> CODEC = RecordCodecBuilder.create(p_191761_ -> p_191761_.group((App)Codec.DOUBLE.fieldOf("noise_level").forGetter(p_191771_ -> p_191771_.noiseLevel), (App)Codec.INT.fieldOf("below_noise").forGetter(p_191769_ -> p_191769_.belowNoise), (App)Codec.INT.fieldOf("above_noise").forGetter(p_191763_ -> p_191763_.aboveNoise)).apply((Applicative)p_191761_, NoiseHeightmap32Placement::new));
    private final double noiseLevel;
    private final int belowNoise;
    private final int aboveNoise;

    public NoiseHeightmap32Placement(double noiseLevel, int belowNoise, int aboveNoise) {
        this.noiseLevel = noiseLevel;
        this.belowNoise = belowNoise;
        this.aboveNoise = aboveNoise;
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
        double d0 = Biome.f_47433_.m_75449_((double)pos.m_123341_() / 200.0, (double)pos.m_123343_() / 200.0, false);
        int i = d0 < this.noiseLevel ? this.belowNoise : this.aboveNoise;
        return IntStream.range(0, i).mapToObj(p_227449_3_ -> {
            int z;
            int x = random.m_188503_(16) + pos.m_123341_();
            int y = context.m_191824_(Heightmap.Types.MOTION_BLOCKING, x, z = random.m_188503_(16) + pos.m_123343_()) + 32;
            return y <= 0 ? null : new BlockPos(x, random.m_188503_(y), z);
        }).filter(Objects::nonNull);
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)EEPlacementModifierTypes.NOISE_HEIGHTMAP_32.get();
    }
}

