/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle.flying;

import com.teamabnormals.endergetic.common.entity.eetle.flying.IFlyingEetle;
import com.teamabnormals.endergetic.common.entity.eetle.flying.TargetFlyingRotations;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;

public final class FlyingEetleMoveController<F extends Mob>
extends MoveControl {
    private final F eetle;
    private final float maxRoll;
    private final float deltaYaw;

    public FlyingEetleMoveController(F flyingEetle, float maxRoll, float deltaYaw) {
        super(flyingEetle);
        this.eetle = flyingEetle;
        this.maxRoll = maxRoll;
        this.deltaYaw = deltaYaw;
    }

    public void m_8126_() {
        F eetle = this.eetle;
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            ((IFlyingEetle)eetle).setMoving(true);
            this.f_24981_ = MoveControl.Operation.WAIT;
            double distanceX = this.f_24975_ - eetle.m_20185_();
            double distanceY = this.f_24976_ - eetle.m_20186_();
            double distanceZ = this.f_24977_ - eetle.m_20189_();
            double magnitude = distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
            if (magnitude < (double)2.5E-7f) {
                eetle.m_21567_(0.0f);
                eetle.m_21564_(0.0f);
                return;
            }
            float yaw = (float)(Mth.m_14136_((double)distanceZ, (double)distanceX) * 57.3) - 90.0f;
            eetle.m_146922_(this.m_24991_(eetle.m_146908_(), yaw, this.deltaYaw));
            float f1 = (float)(this.f_24978_ * eetle.m_21133_(Attributes.f_22280_));
            eetle.m_7910_(f1);
            double horizontalMag = Mth.m_14116_((float)((float)(distanceX * distanceX + distanceZ * distanceZ)));
            float pitch = (float)(-(Mth.m_14136_((double)distanceY, (double)horizontalMag) * 57.3));
            float limitedPitch = this.m_24991_(eetle.m_146909_(), pitch, 40.0f);
            eetle.m_146926_(limitedPitch);
            float targetRoll = 0.0f;
            Vec3 lookVec = eetle.m_20252_(1.0f);
            Vec3 motion = eetle.m_20184_();
            double motionHMag = motion.m_165925_();
            double lookHMag = lookVec.m_165925_();
            if (motionHMag > 0.0 && lookHMag > 0.0) {
                double rollRatio = Mth.m_14008_((double)((motion.f_82479_ * lookVec.f_82479_ + motion.f_82481_ * lookVec.f_82481_) / Math.sqrt(motionHMag * lookHMag)), (double)-1.0, (double)1.0);
                double horizontalDifference = motion.f_82479_ * lookVec.f_82481_ - motion.f_82481_ * lookVec.f_82479_;
                float maxRoll = this.maxRoll;
                targetRoll = Mth.m_14036_((float)((float)(Math.signum(horizontalDifference) * Math.acos(rollRatio) * 57.3)), (float)(-maxRoll), (float)maxRoll);
            }
            ((IFlyingEetle)eetle).setTargetFlyingRotations(new TargetFlyingRotations(limitedPitch, targetRoll));
            eetle.m_21567_(distanceY > 0.0 ? f1 : -f1);
        } else {
            ((IFlyingEetle)eetle).setMoving(false);
            eetle.m_21567_(0.0f);
            eetle.m_21564_(0.0f);
        }
    }
}

