/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.particle;

import com.teamabnormals.endergetic.client.particle.data.CorrockCrownParticleData;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CorrockCrownParticle
extends TextureSheetParticle {
    private final SpriteSet animatedSprite;
    private final float rotSpeed;

    public CorrockCrownParticle(SpriteSet animatedSprite, ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, boolean eetle, Optional<Float> scale) {
        super(world, x, y, z);
        scale.ifPresent(value -> {
            this.f_107663_ = value.floatValue() + value.floatValue() * 0.1f * (this.f_107223_.m_188501_() * 0.5f + 0.5f);
        });
        float size = (float)((eetle ? 0.5 : 0.3) + Math.random() * 0.4);
        this.m_107250_(size, size);
        this.f_107215_ = motionX + motionX * (double)((float)Math.random() - 0.5f) * (double)0.2f;
        this.f_107216_ = motionY + (double)(eetle ? 0.05f : 0.0f);
        this.f_107217_ = motionZ + motionZ * (double)((float)Math.random() - 0.5f) * (double)0.2f;
        this.animatedSprite = animatedSprite;
        this.f_107226_ = eetle ? 0.8f : (float)Math.random() * 0.08f;
        this.f_107231_ = (float)Math.random() * ((float)Math.PI * 2);
        this.f_107225_ = (int)(Math.random() * 20.0 + (double)(eetle ? 20 : 40));
        this.rotSpeed = ((float)Math.random() - 0.5f) * (eetle ? 0.1f : 0.075f);
        this.m_108339_(animatedSprite);
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += (float)Math.PI * this.rotSpeed * 2.0f;
        if (this.f_107218_) {
            this.f_107231_ = 0.0f;
            this.f_107204_ = 0.0f;
        }
        float particleAngle = this.f_107231_;
        this.f_107215_ += Math.cos(particleAngle) * 0.00175;
        this.f_107216_ *= 1.025;
        this.f_107217_ += Math.sin(particleAngle) * 0.00175;
        if (this.m_107276_()) {
            this.m_108339_(this.animatedSprite);
        }
    }

    public int m_6355_(float partialTick) {
        float ageFactor = Mth.m_14036_((float)((float)this.f_107225_ / ((float)this.f_107224_ + (float)this.f_107225_ * 0.5f + partialTick)), (float)0.0f, (float)1.0f);
        int brightnessForRender = super.m_6355_(partialTick);
        int j = brightnessForRender & 0xFF;
        int k = brightnessForRender >> 16 & 0xFF;
        if ((j += (int)(ageFactor * 240.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public static class Factory
    implements ParticleProvider<CorrockCrownParticleData> {
        private SpriteSet animatedSprite;

        public Factory(SpriteSet animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        public Particle createParticle(CorrockCrownParticleData data, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new CorrockCrownParticle(this.animatedSprite, world, x, y, z, xSpeed, ySpeed, zSpeed, data.isEetle(), data.getScale());
        }
    }
}

