/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.common.entity.ai.goal;

import com.teamabnormals.blueprint.core.api.EggLayer;
import com.teamabnormals.incubation.common.block.BirdNestBlock;
import com.teamabnormals.incubation.common.block.EmptyNestBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LayEggInNestGoal
extends MoveToBlockGoal {
    private final Animal bird;
    private final EggLayer eggLayer;
    private int eggCounter;

    public LayEggInNestGoal(Animal birdIn, double speedIn) {
        super((PathfinderMob)birdIn, speedIn, 16);
        this.bird = birdIn;
        this.eggLayer = (EggLayer)birdIn;
    }

    public boolean m_8036_() {
        return this.canEggBeLaid() && super.m_8036_();
    }

    public boolean m_8045_() {
        return this.canEggBeLaid() && super.m_8045_();
    }

    protected int m_6099_(PathfinderMob creatureIn) {
        return 40;
    }

    public void m_8056_() {
        super.m_8056_();
        this.eggCounter = this.m_183277_(30);
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.m_25625_() && this.canEggBeLaid()) {
            this.eggCounter = Math.max(0, this.eggCounter - 1);
            if (this.eggCounter <= 0) {
                int i;
                BlockPos blockpos = this.f_25602_.m_7494_();
                BlockState blockstate = this.bird.m_9236_().m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (block instanceof EmptyNestBlock) {
                    this.bird.m_9236_().m_7731_(blockpos, ((EmptyNestBlock)block).getNest(this.eggLayer.getEggItem()).m_49966_(), 3);
                    this.resetBird();
                } else if (block instanceof BirdNestBlock && ((BirdNestBlock)block).getEgg() == this.eggLayer.getEggItem() && (i = ((Integer)blockstate.m_61143_((Property)BirdNestBlock.EGGS)).intValue()) < 6) {
                    this.bird.m_9236_().m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)BirdNestBlock.EGGS, (Comparable)Integer.valueOf(i + 1)), 3);
                    this.resetBird();
                }
            }
        }
    }

    private boolean canEggBeLaid() {
        return !this.bird.m_6162_() && !this.eggLayer.isBirdJockey() && this.eggLayer.getEggTimer() < 400;
    }

    private void resetBird() {
        RandomSource random = this.bird.m_217043_();
        this.bird.m_5496_(this.eggLayer.getEggLayingSound(), 1.0f, (random.m_188501_() - random.m_188501_()) * 0.2f + 1.0f);
        this.eggLayer.setEggTimer(this.eggLayer.getNextEggTime(random));
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.m_8055_(pos.m_7494_());
        Block block = blockstate.m_60734_();
        return block instanceof EmptyNestBlock || block instanceof BirdNestBlock && ((BirdNestBlock)block).getEgg() == this.eggLayer.getEggItem() && (Integer)blockstate.m_61143_((Property)BirdNestBlock.EGGS) < 6;
    }
}

