/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.crockery;

import earth.terrarium.handcrafted.common.blocks.base.SimpleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrockeryBlock
extends SimpleBlock {
    public static final IntegerProperty PIECES = IntegerProperty.m_61631_((String)"pieces", (int)1, (int)6);
    public static final VoxelShape SHAPE_1 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    public static final VoxelShape SHAPE_2 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    public static final VoxelShape SHAPE_3 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
    public static final VoxelShape SHAPE_4 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    public static final VoxelShape SHAPE_5 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    public static final VoxelShape SHAPE_6 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);

    public CrockeryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PIECES, (Comparable)Integer.valueOf(1))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PIECES, WATERLOGGED});
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return !useContext.m_7078_() && useContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)PIECES) < 6 || super.m_6864_(state, useContext);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.m_61143_((Property)PIECES)) {
            case 2 -> SHAPE_2;
            case 3 -> SHAPE_3;
            case 4 -> SHAPE_4;
            case 5 -> SHAPE_5;
            case 6 -> SHAPE_6;
            default -> SHAPE_1;
        };
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (state.m_60713_((Block)this)) {
            return (BlockState)state.m_61124_((Property)PIECES, (Comparable)Integer.valueOf(Math.min(6, (Integer)state.m_61143_((Property)PIECES) + 1)));
        }
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean bl = fluidState.m_76152_() == Fluids.f_76193_;
        BlockState placementState = super.m_5573_(context);
        if (placementState == null) {
            return null;
        }
        return (BlockState)placementState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    public static String piecesName(BlockState state) {
        return switch ((Integer)state.m_61143_((Property)PIECES)) {
            case 2 -> "double";
            case 3 -> "triple";
            case 4 -> "quadruple";
            case 5 -> "quintuple";
            case 6 -> "sextuple";
            default -> "single";
        };
    }
}

