/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.projectile;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.The_Harbinger_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class Wither_Homing_Missile_Entity
extends Projectile {
    public double accelerationPower = 0.1;
    @Nullable
    private Entity finalTarget;
    @Nullable
    private UUID targetId;
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(Wither_Homing_Missile_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> FUSE = SynchedEntityData.m_135353_(Wither_Homing_Missile_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3[] trailPositions = new Vec3[64];
    private int trailPointer = -1;

    public Wither_Homing_Missile_Entity(EntityType<? extends Wither_Homing_Missile_Entity> p_36833_, Level p_36834_) {
        super(p_36833_, p_36834_);
    }

    public Wither_Homing_Missile_Entity(Level worldIn, LivingEntity entity) {
        this((EntityType<? extends Wither_Homing_Missile_Entity>)((EntityType)ModEntities.WITHER_HOMING_MISSILE.get()), worldIn);
        this.m_5602_((Entity)entity);
    }

    public Wither_Homing_Missile_Entity(EntityType<? extends Wither_Homing_Missile_Entity> p_36817_, double p_36818_, double p_36819_, double p_36820_, Vec3 vec3, Level p_36824_) {
        this(p_36817_, p_36824_);
        this.m_7678_(p_36818_, p_36819_, p_36820_, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        this.assignDirectionalMovement(vec3, this.accelerationPower);
    }

    public Wither_Homing_Missile_Entity(LivingEntity p_36827_, Vec3 vec3, Level p_36831_, float damage, LivingEntity target) {
        this((EntityType<? extends Wither_Homing_Missile_Entity>)((EntityType)ModEntities.WITHER_HOMING_MISSILE.get()), p_36827_.m_20185_(), p_36827_.m_20186_(), p_36827_.m_20189_(), vec3, p_36831_);
        this.m_5602_((Entity)p_36827_);
        this.setDamage(damage);
        this.m_19915_(p_36827_.m_146908_(), p_36827_.m_146909_());
        this.setFuse(80);
        this.finalTarget = target;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FUSE, (Object)80);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public void setFuse(int life) {
        this.f_19804_.m_135381_(FUSE, (Object)life);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(FUSE);
    }

    public boolean m_6783_(double p_36837_) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return p_36837_ < (d0 *= 64.0) * d0;
    }

    public void m_7380_(CompoundTag p_37357_) {
        super.m_7380_(p_37357_);
        if (this.finalTarget != null) {
            p_37357_.m_128362_("Target", this.finalTarget.m_20148_());
        }
        p_37357_.m_128347_("acceleration_power", this.accelerationPower);
        p_37357_.m_128376_("fuse", (short)this.getFuse());
    }

    public void m_7378_(CompoundTag p_37353_) {
        super.m_7378_(p_37353_);
        this.setFuse(p_37353_.m_128448_("fuse"));
        if (p_37353_.m_128403_("Target")) {
            this.targetId = p_37353_.m_128342_("Target");
        }
        if (p_37353_.m_128425_("acceleration_power", 6)) {
            this.accelerationPower = p_37353_.m_128459_("acceleration_power");
        }
    }

    public void m_8119_() {
        Entity entity = this.m_19749_();
        if (this.m_9236_().f_46443_ || (entity == null || !entity.m_213877_()) && this.m_9236_().m_46805_(this.m_20183_())) {
            super.m_8119_();
            HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
            if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            this.m_20101_();
            Vec3 vec3 = this.m_20184_();
            double d0 = this.m_20185_() + vec3.f_82479_;
            double d1 = this.m_20186_() + vec3.f_82480_;
            double d2 = this.m_20189_() + vec3.f_82481_;
            ProjectileUtil.m_37284_((Entity)this, (float)1.0f);
            float f = this.getInertia();
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    float f1 = 0.25f;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d0 - vec3.f_82479_ * 0.25, d1 - vec3.f_82480_ * 0.25, d2 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
                f = 0.8f;
            }
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() - vec3.f_82479_, this.m_20186_() - vec3.f_82480_ + 0.15, this.m_20189_() - vec3.f_82481_, 0.0, 0.0, 0.0);
            this.m_20256_(vec3.m_82549_(vec3.m_82541_().m_82490_(this.accelerationPower)).m_82490_((double)f));
            this.m_6034_(d0, d1, d2);
        } else {
            this.m_146870_();
        }
        int f = this.getFuse() - 1;
        this.setFuse(f);
        if (!this.m_9236_().f_46443_) {
            if (this.finalTarget == null && this.targetId != null) {
                this.finalTarget = ((ServerLevel)this.m_9236_()).m_8791_(this.targetId);
                if (this.finalTarget == null) {
                    this.targetId = null;
                }
            }
            if (this.finalTarget == null || !this.finalTarget.m_6084_() || this.finalTarget instanceof Player && this.finalTarget.m_5833_()) {
                this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, false, Level.ExplosionInteraction.NONE);
                this.m_146870_();
            } else {
                Vec3 target = new Vec3(this.finalTarget.m_20185_(), this.finalTarget.m_20227_(0.5), this.finalTarget.m_20189_());
                Vec3 currentVelocity = this.m_20184_();
                Vec3 toTarget = target.m_82546_(this.m_20182_());
                double distance = toTarget.m_82553_();
                if (distance > 0.1) {
                    Vec3 desiredDirection = toTarget.m_82541_();
                    double homingStrength = Mth.m_14008_((double)((distance - 1.0) / 10.0), (double)0.1, (double)1.0);
                    Vec3 newDirection = currentVelocity.m_82541_().m_82490_(1.0 - homingStrength).m_82549_(desiredDirection.m_82490_(homingStrength)).m_82541_().m_82490_(currentVelocity.m_82553_());
                    this.assignDirectionalMovement(newDirection, this.getInertia());
                }
            }
            if (f <= 0) {
                this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, false, Level.ExplosionInteraction.NONE);
                this.m_146870_();
            }
        }
        Vec3 trailAt = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        if (this.trailPointer == -1) {
            Vec3 backAt = trailAt;
            for (int i = 0; i < this.trailPositions.length; ++i) {
                this.trailPositions[i] = backAt;
            }
        }
        if (++this.trailPointer == this.trailPositions.length) {
            this.trailPointer = 0;
        }
        this.trailPositions[this.trailPointer] = trailAt;
    }

    protected void m_5790_(EntityHitResult p_37626_) {
        super.m_5790_(p_37626_);
        if (!this.m_9236_().f_46443_ && !(p_37626_.m_82443_() instanceof The_Harbinger_Entity)) {
            boolean flag;
            Entity entity = p_37626_.m_82443_();
            Entity entity1 = this.m_19749_();
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity1;
                flag = entity.m_6469_(this.m_269291_().m_269299_((Entity)this, livingentity), this.getDamage());
                if (flag) {
                    if (entity.m_6084_()) {
                        this.m_19970_(livingentity, entity);
                    } else if (entity1 instanceof The_Harbinger_Entity) {
                        livingentity.m_5634_(5.0f * (float)CMConfig.HarbingerHealingMultiplier);
                    } else {
                        livingentity.m_5634_(5.0f);
                    }
                }
            } else {
                flag = entity.m_6469_(this.m_269291_().m_269425_(), 3.0f);
            }
            if (flag && entity instanceof LivingEntity) {
                int i = 5;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    i = 10;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    i = 15;
                }
                ((LivingEntity)entity).m_147207_(new MobEffectInstance(MobEffects.f_19615_, 5 * i, 0), this.m_150173_());
            }
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, false, Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, false, Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult ray) {
        HitResult.Type raytraceresult$type = ray.m_6662_();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)ray);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.m_8060_((BlockHitResult)ray);
        }
    }

    protected boolean m_5603_(Entity p_36842_) {
        return super.m_5603_(p_36842_) && !p_36842_.f_19794_;
    }

    protected float getInertia() {
        return 0.6f;
    }

    public boolean m_6087_() {
        return false;
    }

    public float m_6143_() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource p_37616_, float p_37617_) {
        return false;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Vec3 getTrailPosition(int pointer, float partialTick) {
        if (this.m_213877_()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        Vec3 d0 = this.trailPositions[j];
        Vec3 d1 = this.trailPositions[i].m_82546_(d0);
        return d0.m_82549_(d1.m_82490_((double)partialTick));
    }

    public boolean hasTrail() {
        return this.trailPointer != -1;
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        Vec3 vec3 = new Vec3(packet.m_131503_(), packet.m_131504_(), packet.m_131505_());
        this.m_20256_(vec3);
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
    }

    private void assignDirectionalMovement(Vec3 movement, double accelerationPower) {
        this.m_20256_(movement.m_82541_().m_82490_(accelerationPower));
        this.f_19812_ = true;
    }
}

