/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.particle;

import com.github.L_Ender.cataclysm.client.particle.AbstractTrailParticle;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpinTrailParticle
extends AbstractTrailParticle {
    private static final ResourceLocation PROTON_TRAIL_TEXTURE = new ResourceLocation("cataclysm", "textures/particle/gathering_lightning.png");
    protected double orbitX;
    protected double orbitY;
    protected double orbitZ;
    protected double orbitDistance;
    protected Vec3 orbitOffset;
    protected boolean reverseOrbit;
    protected int orbitAxis;
    protected float orbitSpeed = 1.0f;

    public SpinTrailParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd, float r, float g, float b) {
        super(world, x, y, z, 0.0, 0.0, 0.0, r, g, b);
        this.trailA = 0.8f;
        this.f_107225_ = 50 + this.f_107223_.m_188503_(30);
        this.f_107226_ = 0.0f;
        this.orbitX = xd;
        this.orbitY = yd;
        this.orbitZ = zd;
        this.orbitDistance = 4.0;
        this.orbitOffset = new Vec3(0.0, 0.0, 0.0);
        this.reverseOrbit = this.f_107223_.m_188499_();
        this.orbitAxis = this.f_107223_.m_188503_(2);
        this.orbitSpeed = 10.0f;
    }

    public Vec3 getOrbitPosition(float angle) {
        Vec3 center = new Vec3(this.orbitX, this.orbitY, this.orbitZ);
        float f = this.reverseOrbit ? -1.0f : 1.0f;
        Vec3 add = Vec3.f_82478_;
        float rot = angle * 3.0f * this.orbitSpeed * ((float)Math.PI / 180);
        switch (this.orbitAxis) {
            case 0: {
                add = new Vec3(0.0, this.orbitDistance * 0.5, this.orbitDistance * 0.5).m_82496_(rot * f);
                break;
            }
            case 1: {
                add = new Vec3(this.orbitDistance * 0.5, 0.0, this.orbitDistance * 0.5).m_82524_(rot * f);
                break;
            }
            case 2: {
                add = new Vec3(this.orbitDistance * 0.5, this.orbitDistance * 0.5, 0.0).m_82535_(rot * f);
            }
        }
        return center.m_82549_(add);
    }

    @Override
    public void m_5989_() {
        Vec3 vec3 = this.getOrbitPosition(this.f_107224_);
        Vec3 movement = vec3.m_82492_(this.f_107212_, this.f_107213_, this.f_107214_).m_82541_().m_82490_((double)(this.orbitSpeed * 0.01f));
        this.f_107215_ += movement.f_82479_;
        this.f_107216_ += movement.f_82480_;
        this.f_107217_ += movement.f_82481_;
        float fade = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        this.trailA = 0.8f * fade;
        super.m_5989_();
    }

    public int m_6355_(float f) {
        return 240;
    }

    @Override
    public float getTrailHeight() {
        return 0.2f;
    }

    @Override
    public ResourceLocation getTrailTexture() {
        return PROTON_TRAIL_TEXTURE;
    }

    @Override
    public int sampleCount() {
        return Math.min(10, this.f_107225_ - this.f_107224_);
    }

    public static class SpinData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<SpinData> DESERIALIZER = new ParticleOptions.Deserializer<SpinData>(){

            public SpinData fromCommand(ParticleType<SpinData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float r = reader.readFloat();
                reader.expect(' ');
                float g = reader.readFloat();
                reader.expect(' ');
                float b = reader.readFloat();
                return new SpinData(r, g, b);
            }

            public SpinData fromNetwork(ParticleType<SpinData> particleTypeIn, FriendlyByteBuf buffer) {
                return new SpinData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };
        private final float r;
        private final float g;
        private final float b;

        public SpinData(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
        }

        public ParticleType<SpinData> m_6012_() {
            return (ParticleType)ModParticle.SPIN_TRAIL_PARTICLE.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getB() {
            return this.b;
        }

        public static Codec<SpinData> CODEC(ParticleType<SpinData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("r").forGetter(SpinData::getR), (App)Codec.FLOAT.fieldOf("g").forGetter(SpinData::getG), (App)Codec.FLOAT.fieldOf("b").forGetter(SpinData::getB)).apply((Applicative)codecBuilder, SpinData::new));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SpinData> {
        public Particle createParticle(SpinData data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SpinTrailParticle particle = new SpinTrailParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, data.getR(), data.getG(), data.getB());
            return particle;
        }
    }
}

