/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.visual;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.lpcamors.optical.COPartialModels;
import net.lpcamors.optical.blocks.optical_receptor.OpticalReceptorBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;

public class ReceptorVisual
extends ShaftVisual<OpticalReceptorBlockEntity>
implements SimpleDynamicVisual {
    int light;
    Map<OrientedInstance, Direction> sensorInstances = new HashMap<OrientedInstance, Direction>();
    protected final PoseStack ms = new PoseStack();

    public ReceptorVisual(VisualizationContext context, OpticalReceptorBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        this.setup();
        this.sensorInstances.forEach(this::rotateSensor);
    }

    public void beginFrame(DynamicVisual.Context context) {
        this.setup();
        this.sensorInstances.forEach(this::rotateSensor);
    }

    public void rotateSensor(OrientedInstance orientedInstance, Direction direction) {
        ((OrientedInstance)orientedInstance.position(this.getVisualPosition().m_252807_()).translatePivot(-0.5f, -0.5f, -0.5f).rotateToFace(direction)).light(this.light).setChanged();
    }

    public void setup() {
        this.deleteSensors();
        Instancer sensor = this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)COPartialModels.OPTICAL_DEVICE_HORIZONTAL));
        for (int i = 0; i < ((OpticalReceptorBlockEntity)this.blockEntity).sensor.size(); ++i) {
            Direction direction = ((OpticalReceptorBlockEntity)this.blockEntity).integerDirectionMap.get(i);
            if (((ItemStack)((OpticalReceptorBlockEntity)this.blockEntity).sensor.get(i)).m_41619_() || direction == null) continue;
            this.sensorInstances.put((OrientedInstance)sensor.createInstance(), direction);
        }
    }

    private void deleteSensors() {
        this.sensorInstances.forEach((orientedInstance, direction) -> orientedInstance.delete());
        this.sensorInstances.clear();
    }

    protected void _delete() {
        this.deleteSensors();
        super._delete();
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.light = this.computePackedLight();
        this.sensorInstances.forEach((orientedInstance, direction) -> this.relight(this.pos.m_121945_(direction), new FlatLit[0]));
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        this.sensorInstances.forEach((orientedInstance, direction) -> consumer.accept((Instance)orientedInstance));
    }
}

