/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.gui;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.ScreenElement;
import net.lpcamors.optical.blocks.hologram_source.HologramSourceBlockEntity;
import net.lpcamors.optical.data.COLang;
import net.lpcamors.optical.gui.COGuiTextures;
import net.lpcamors.optical.network.COPackets;
import net.lpcamors.optical.network.ConfigureHologramSourcePacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class HologramSourceScreen
extends AbstractSimiScreen {
    private final COGuiTextures background = COGuiTextures.HOLOGRAM;
    private final Component modeTitle = COLang.Prefixes.OPTICAL.translate("gui.hologram_source.mode", new Object[0]);
    private ScrollInput modeArea;
    private ScrollInput angleArea;
    private boolean shouldRenderAngle = false;
    private IconButton confirmButton;
    private Label modeLabel;
    private final CompoundTag tag;
    private int modeIndex;
    private int angle;
    final HologramSourceBlockEntity be;

    public HologramSourceScreen(HologramSourceBlockEntity be) {
        super((Component)COLang.Prefixes.OPTICAL.translate("gui.hologram_source.title", new Object[0]));
        this.be = be;
        this.modeIndex = be.getMode().ordinal();
        this.angle = be.getFixedAngle();
        this.tag = be.getModeData();
    }

    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(0, 0);
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> ((HologramSourceScreen)this).m_7379_());
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.modeLabel = new Label(x + 29, y + 28, (Component)Component.m_237119_()).withShadow();
        this.modeLabel.text = Component.m_237119_();
        this.modeArea = new SelectionScrollInput(x + 22, y + 23, 109, 18).forOptions(HologramSourceBlockEntity.Mode.getComponents()).titled(this.modeTitle.m_6879_()).calling(integer -> {
            this.modeIndex = integer;
        }).setState(this.modeIndex).writingTo(this.modeLabel);
        this.shouldRenderAngle = HologramSourceBlockEntity.Mode.values()[this.modeIndex].isShouldRenderAngle();
        this.angleArea = new ScrollInput(x + 133, y + 23, 28, 18).withRange(0, 360).calling(integer -> {
            this.angle = integer;
        }).setState(this.angle);
        this.m_142416_((GuiEventListener)this.modeArea);
        this.m_142416_((GuiEventListener)this.angleArea);
    }

    public void sendPacket() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("ModeIndex", this.modeIndex);
        tag.m_128405_("Angle", this.angle);
        if (tag.equals((Object)this.tag)) {
            return;
        }
        COPackets.getChannel().sendToServer((Object)new ConfigureHologramSourcePacket(this.be.m_58899_(), tag));
    }

    public void m_7861_() {
        this.sendPacket();
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        graphics.m_280614_(this.f_96547_, this.f_96539_, x + (this.background.width - 8) / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, y + 4, 5841956, false);
        this.label(graphics, 30, 28, (Component)COLang.Prefixes.OPTICAL.translate(HologramSourceBlockEntity.Mode.values()[this.modeArea.getState()].getTranslationKey(), new Object[0]));
        this.angleArea.f_93624_ = this.shouldRenderAngle = HologramSourceBlockEntity.Mode.values()[this.modeArea.getState()].isShouldRenderAngle();
        if (this.shouldRenderAngle) {
            COGuiTextures toDraw = COGuiTextures.HOLOGRAM_PLUS_SLOT;
            toDraw.render(graphics, x + 130, y + 23);
            MutableComponent c = Component.m_237113_((String)(this.angleArea.getState() + "\u00b0"));
            this.label(graphics, 148 - this.f_96547_.m_92852_((FormattedText)c) / 2, 28, (Component)c);
        }
    }

    private void label(GuiGraphics graphics, int x, int y, Component text) {
        graphics.m_280430_(this.f_96547_, text, this.guiLeft + x, this.guiTop + y, 0xFFFFEE);
    }
}

