/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.thermal_optical_source;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.List;
import net.lpcamors.optical.blocks.optical_source.OpticalSourceBlockEntity;
import net.lpcamors.optical.blocks.thermal_optical_source.ThermalOpticalSourceBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ThermalOpticalSourceBlockEntity
extends OpticalSourceBlockEntity {
    public SmartFluidTankBehaviour internalTank;

    public ThermalOpticalSourceBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isActive() && this.getTickCount() % 24 == 0) {
            this.internalTank.getPrimaryHandler().drain(1, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.internalTank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000).allowExtraction().allowInsertion();
        behaviours.add((BlockEntityBehaviour)this.internalTank);
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.internalTank.getPrimaryHandler().getFluidAmount() > 0;
    }

    @Override
    public float getIntensity() {
        Fluid fluid = this.internalTank.getPrimaryHandler().getFluid().getFluid();
        return super.getIntensity() * (Fluids.f_76193_.m_5613_().m_6212_(fluid) ? 2.0f : (Fluids.f_76195_.m_5613_().m_6212_(fluid) ? 4.0f : 1.0f));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && ThermalOpticalSourceBlock.hasPipeTowards((LevelReader)this.f_58857_, this.f_58858_, this.m_58900_(), side)) {
            return this.internalTank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }
}

