/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.optical_source;

import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.gui.AllIcons;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.createmod.catnip.nbt.NBTHelper;
import net.lpcamors.optical.CODamageSources;
import net.lpcamors.optical.COIcons;
import net.lpcamors.optical.COUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeamHelper {
    public static boolean canBeamPassThrough(@Nonnull Block block) {
        List<Class<CarpetBlock>> classes = List.of(HalfTransparentBlock.class, SlabBlock.class, CarpetBlock.class);
        boolean[] result = new boolean[]{true};
        classes.forEach(aClass -> {
            result[0] = result[0] || block.getClass().equals(aClass);
        });
        return result[0] && block instanceof TintedGlassBlock;
    }

    public static Vec3i ofDyeColor(DyeColor dyeColor) {
        float[] floats = dyeColor.m_41068_();
        return new Vec3i((int)(floats[0] * 255.0f), (int)(floats[1] * 255.0f), (int)(floats[2] * 255.0f));
    }

    public static Vec3i colorSum(Vec3i rgb1, Vec3i rgb2) {
        if (rgb1.m_203202_(250.0, 250.0, 250.0) <= 125.0) {
            return rgb2;
        }
        Vec3 v = Vec3.m_82528_((Vec3i)rgb1).m_82549_(Vec3.m_82528_((Vec3i)rgb2)).m_82542_(0.5, 0.5, 0.5);
        return new Vec3i((int)v.f_82479_, (int)v.f_82480_, (int)v.f_82481_);
    }

    public static BiConsumer<LivingEntity, BeamProperties> livingEntityNothing() {
        return (livingEntity, beamProperties) -> {};
    }

    public static BiConsumer<BlockState, BeamProperties> blockStateNothing() {
        return (livingEntity, beamProperties) -> {};
    }

    public static BiConsumer<ItemEntity, BeamProperties> itemEntityNothing() {
        return (livingEntity, beamProperties) -> {};
    }

    public static BiConsumer<BlockState, BeamProperties> activateRadio() {
        return (itemEntity, beamProperties) -> {};
    }

    public static BiConsumer<ItemEntity, BeamProperties> cookFood() {
        return (itemEntity, beamProperties) -> {};
    }

    public static BiConsumer<LivingEntity, BeamProperties> dealDamage() {
        return (livingEntity, beamProperties) -> {
            float damage;
            float f = damage = 3.0f * beamProperties.intensity <= 0.25f ? 0.0f : beamProperties.intensity;
            if (damage > 0.0f) {
                livingEntity.m_6469_(CODamageSources.gammaRay(livingEntity.m_9236_()), damage);
            }
        };
    }

    public static class BeamProperties {
        public static float SPEED_CONSTANT = 4.0f;
        public final float intensity;
        public final BeamPolarization beamPolarization;
        public Vec3i color;
        public final Direction direction;
        public final Boolean spin;
        public final BeamType beamType;
        public int changedColors = 1;
        public boolean forceVisibility = false;
        public boolean forcePenetration = false;

        public static float intensityBySpeed(float speed) {
            return Math.abs(speed / SPEED_CONSTANT);
        }

        public static boolean spinBySpeed(float speed) {
            return speed > 0.0f;
        }

        public static BeamProperties withDirection(BeamProperties beamProperties, Direction direction) {
            return new BeamProperties(beamProperties.intensity, beamProperties.beamPolarization, beamProperties.color, direction, beamProperties.spin, beamProperties.beamType);
        }

        public BeamProperties(float intensity, BeamPolarization beamPolarization, Direction direction, boolean spin, BeamType beamType) {
            this(intensity, beamPolarization, COUtils.getColor(DyeColor.WHITE), direction, spin, beamType);
        }

        public BeamProperties(float intensity, BeamPolarization beamPolarization, Vec3i color, Direction direction, boolean spin, BeamType beamType) {
            this.intensity = intensity;
            this.beamPolarization = beamPolarization;
            this.color = color;
            this.direction = direction;
            this.spin = spin;
            this.beamType = beamType;
        }

        public static BeamProperties sum(Direction direction, List<BeamProperties> beamProperties) {
            float intensity = 0.0f;
            BeamPolarization beamPolarization = beamProperties.get((int)0).beamPolarization;
            boolean forcePol = false;
            Vec3i color = null;
            BeamType type = beamProperties.get((int)0).beamType;
            boolean hasVisible = false;
            boolean spin = true;
            for (BeamProperties beamProperties1 : beamProperties) {
                if (intensity < beamProperties1.intensity) {
                    type = beamProperties1.beamType;
                    spin = beamProperties1.spin;
                }
                intensity += beamProperties1.intensity;
                if (!forcePol && beamPolarization != beamProperties1.beamPolarization && beamProperties1.beamPolarization != BeamPolarization.RANDOM) {
                    if (beamPolarization != BeamPolarization.RANDOM) {
                        beamPolarization = BeamPolarization.RANDOM;
                        forcePol = true;
                    } else {
                        beamPolarization = beamProperties1.beamPolarization;
                    }
                }
                if (!beamProperties1.beamType.visible()) continue;
                hasVisible = true;
                if (color == null) {
                    color = beamProperties1.color;
                    continue;
                }
                color = BeamHelper.colorSum(color, beamProperties1.color);
            }
            color = color == null ? COUtils.getColor(DyeColor.WHITE) : color;
            BeamProperties beamProperties1 = new BeamProperties(intensity, beamPolarization, color, direction, spin, type);
            beamProperties1.forceVisibility = hasVisible;
            beamProperties1.forcePenetration = type.canPassThroughEntities();
            return beamProperties1;
        }

        public float getTheoreticalIntensitySpeed() {
            return SPEED_CONSTANT * this.intensity * (float)(this.spin != false ? 1 : -1);
        }

        public BeamType getType() {
            return this.beamType;
        }

        public boolean isVisible() {
            return this.beamType.visible() || this.forceVisibility;
        }

        public boolean canPassThroughEntities() {
            return this.beamType.canPassThroughEntities() || this.forcePenetration;
        }

        public boolean equals(Object obj) {
            BeamProperties beamProperties;
            BeamProperties beamProperties2 = beamProperties = obj instanceof BeamProperties ? (BeamProperties)obj : null;
            if (obj == null) {
                return false;
            }
            boolean f = beamProperties.intensity == this.intensity && beamProperties.beamPolarization == this.beamPolarization && beamProperties.color.equals((Object)this.color) && beamProperties.direction == this.direction && beamProperties.beamType == this.beamType && beamProperties.forceVisibility == this.forceVisibility && beamProperties.forcePenetration == this.forcePenetration && beamProperties.spin == this.spin;
            return f;
        }

        public void write(CompoundTag compoundTag) {
            ListTag listTag = new ListTag();
            ListTag tagFloats = new ListTag();
            ListTag tagInts = new ListTag();
            ListTag tagBoolean = new ListTag();
            ListTag color = NBTHelper.writeVec3i((Vec3i)this.color);
            tagFloats.add((Object)FloatTag.m_128566_((float)this.intensity));
            tagInts.add((Object)IntTag.m_128679_((int)this.beamPolarization.id));
            tagInts.add((Object)IntTag.m_128679_((int)(this.direction == null ? 0 : List.of(Direction.values()).indexOf(this.direction))));
            tagInts.add((Object)IntTag.m_128679_((int)(this.forceVisibility ? 1 : 0)));
            tagInts.add((Object)IntTag.m_128679_((int)(this.forcePenetration ? 1 : 0)));
            tagInts.add((Object)IntTag.m_128679_((int)this.beamType.ordinal()));
            tagInts.add((Object)IntTag.m_128679_((int)(this.spin != false ? 1 : 0)));
            listTag.add((Object)tagFloats);
            listTag.add((Object)tagInts);
            listTag.add((Object)tagBoolean);
            listTag.add((Object)color);
            compoundTag.m_128365_("BeamProperties", (Tag)listTag);
        }

        public static Optional<BeamProperties> read(CompoundTag compoundTag) {
            try {
                if (!compoundTag.m_128441_("BeamProperties")) {
                    return Optional.empty();
                }
                ListTag listTag = (ListTag)compoundTag.m_128423_("BeamProperties");
                ListTag tagFloats = listTag.m_128744_(0);
                ListTag tagInts = listTag.m_128744_(1);
                ListTag tagBoolean = listTag.m_128744_(2);
                ListTag color = listTag.m_128744_(3);
                BeamProperties beamProperties = new BeamProperties(((FloatTag)tagFloats.get(0)).m_7057_(), BeamPolarization.values()[((IntTag)tagInts.get(0)).m_7047_()], NBTHelper.readVec3i((ListTag)color), Direction.values()[tagInts.m_128763_(1)], tagInts.m_128763_(5) != 0, BeamType.values()[((IntTag)tagInts.get(4)).m_7047_()]);
                beamProperties.forceVisibility = tagInts.m_128763_(2) == 1;
                beamProperties.forcePenetration = tagInts.m_128763_(3) == 1;
                return Optional.of(beamProperties);
            }
            catch (Exception e) {
                e.fillInStackTrace();
                System.out.println("Hi, that is a common error. It happens when you're loading an older version world.");
                return Optional.empty();
            }
        }
    }

    public static enum BeamType {
        RADIO(0, BeamHelper.livingEntityNothing(), BeamHelper.activateRadio(), BeamHelper.itemEntityNothing()),
        MICROWAVE(1, BeamHelper.livingEntityNothing(), BeamHelper.blockStateNothing(), BeamHelper.cookFood()),
        VISIBLE(2, BeamHelper.livingEntityNothing(), BeamHelper.blockStateNothing(), BeamHelper.itemEntityNothing()),
        GAMMA(3, BeamHelper.dealDamage(), BeamHelper.blockStateNothing(), BeamHelper.itemEntityNothing());

        public final int id;
        public final BiConsumer<LivingEntity, BeamProperties> livingEntityBiConsumer;
        public final BiConsumer<BlockState, BeamProperties> blockStateBiConsumer;
        public final BiConsumer<ItemEntity, BeamProperties> itemEntityBiConsumer;

        private BeamType(int id, BiConsumer<LivingEntity, BeamProperties> livingEntityBiConsumer, BiConsumer<BlockState, BeamProperties> blockStateBiConsumer, BiConsumer<ItemEntity, BeamProperties> itemEntityBiConsumer) {
            this.id = id;
            this.livingEntityBiConsumer = livingEntityBiConsumer;
            this.blockStateBiConsumer = blockStateBiConsumer;
            this.itemEntityBiConsumer = itemEntityBiConsumer;
        }

        public int getRange() {
            return (4 - this.ordinal()) * 32;
        }

        public static BeamType getTypeBySpeed(float speed) {
            BeamType beamType = RADIO;
            BeamType[] beamTypeArray = BeamType.values();
            int n = beamTypeArray.length;
            for (int i = 0; i < n; ++i) {
                BeamType beamType1;
                beamType = beamType1 = beamTypeArray[i];
                if ((double)Math.abs(speed) <= Math.pow(2.0, 2 * beamType1.id + 3)) break;
            }
            return beamType;
        }

        public boolean visible() {
            return this.equals((Object)VISIBLE);
        }

        public boolean canPassThroughEntities() {
            return this.equals((Object)GAMMA);
        }

        public String getDescriptionId() {
            return "beam_type.type." + this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum BeamPolarization implements StringRepresentable,
    INamedIconOptions
    {
        RANDOM(0, null, "", COIcons.POL_RANDOM),
        HORIZONTAL(1, 0, "\u2b05\u27a1", COIcons.POL_HORIZONTAL),
        DIAGONAL_POSITIVE(2, 1, "\u2b0b\u2b08", COIcons.POL_DIAGONAL_POSITIVE),
        VERTICAL(3, 2, " \u2b07\u2b06 ", COIcons.POL_VERTICAL),
        DIAGONAL_NEGATIVE(4, 3, "\u2b0a\u2b09", COIcons.POL_DIAGONAL_NEGATIVE);

        final int id;
        @Nullable
        final Integer angle;
        final String sIcon;
        final COIcons coIcons;

        private BeamPolarization(int id, Integer angle, String sIcon, COIcons coIcons) {
            this.id = id;
            this.angle = angle;
            this.sIcon = sIcon;
            this.coIcons = coIcons;
        }

        public BeamPolarization getNextRotated(Integer angle) {
            if (!this.equals((Object)RANDOM)) {
                Integer newAngle = (this.angle + angle) % 4;
                return this.byAngle(newAngle);
            }
            return RANDOM;
        }

        public String getsIcon() {
            return this.sIcon;
        }

        public int getId() {
            return this.id;
        }

        public BeamPolarization byAngle(Integer angle) {
            AtomicReference<BeamPolarization> beamPolarization = new AtomicReference<BeamPolarization>(RANDOM);
            Arrays.stream(BeamPolarization.values()).forEach(laserBeamPolarization1 -> {
                if (laserBeamPolarization1.angle != null && laserBeamPolarization1.angle.equals(angle)) {
                    beamPolarization.set((BeamPolarization)((Object)laserBeamPolarization1));
                }
            });
            return beamPolarization.get();
        }

        public boolean isDiagonal() {
            return this.equals((Object)DIAGONAL_NEGATIVE) || this.equals((Object)DIAGONAL_POSITIVE);
        }

        @Nullable
        public Integer getAngle() {
            return this.angle;
        }

        public float getRemainingIntensity(float intensity, BeamPolarization beamPolarization) {
            float f = beamPolarization.equals((Object)this) || beamPolarization.equals((Object)RANDOM) ? 1.0f : (this.equals((Object)RANDOM) ? 0.5f : (this.angle % 2 == beamPolarization.angle % 2 ? 0.0f : 0.5f));
            return f * intensity;
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String getDescriptionId() {
            return this.getTranslationKey();
        }

        public AllIcons getIcon() {
            return this.coIcons;
        }

        public String getTranslationKey() {
            return "polarization." + this.m_7912_();
        }
    }
}

