/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.hologram_source;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.data.AssetLookup;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.createmod.catnip.gui.ScreenOpener;
import net.lpcamors.optical.COShapes;
import net.lpcamors.optical.COUtils;
import net.lpcamors.optical.blocks.COBlockEntities;
import net.lpcamors.optical.blocks.IBeamReceiver;
import net.lpcamors.optical.blocks.IBeamSource;
import net.lpcamors.optical.blocks.hologram_source.HologramSourceBlockEntity;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.lpcamors.optical.gui.HologramSourceScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;

public class HologramSourceBlock
extends HorizontalDirectionalBlock
implements IBeamReceiver,
IWrenchable,
IBE<HologramSourceBlockEntity> {
    public static final BooleanProperty CONNECTED_POSITIVE = BooleanProperty.m_61465_((String)"positive_connection");
    public static final BooleanProperty CONNECTED_NEGATIVE = BooleanProperty.m_61465_((String)"negative_connection");

    public HologramSourceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CONNECTED_POSITIVE, (Comparable)Boolean.FALSE));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CONNECTED_NEGATIVE, (Comparable)Boolean.FALSE));
    }

    @Override
    public boolean useCenteredIncidence() {
        return false;
    }

    public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        return HologramSourceBlock.updateStateConnections(super.updateAfterWrenched(newState, context), (BlockGetter)context.m_43725_(), context.m_8083_());
    }

    @Override
    public void receive(IBeamSource iBeamSource, BlockState state, BlockPos lastPos, BeamHelper.BeamProperties beamProperties, int lastIndex) {
        Direction direction = beamProperties.direction;
        HologramSourceBlockEntity be = (HologramSourceBlockEntity)this.getBlockEntity((BlockGetter)iBeamSource.m_58904_(), lastPos);
        if (!beamProperties.getType().equals((Object)BeamHelper.BeamType.VISIBLE) || be == null || ((Direction)state.m_61143_((Property)f_54117_)).m_122434_().equals((Object)direction.m_122434_())) {
            return;
        }
        IBeamSource.propagateLinearBeamVar(iBeamSource, lastPos, beamProperties, lastIndex);
        if (be.m_58898_() && be.m_58904_().f_46443_) {
            return;
        }
        if (be.changeState(iBeamSource.m_58899_(), beamProperties)) {
            iBeamSource.addDependent(be.m_58899_());
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean p_60519_) {
        super.m_6810_(state, world, pos, newState, p_60519_);
        if (world.f_46443_) {
            return;
        }
        world.m_46747_(pos);
        HologramSourceBlock.updateNeighbourConnections(state, world, pos, true);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos otherPos, boolean p_60514_) {
        super.m_6861_(state, level, pos, block, otherPos, p_60514_);
        if (level.f_46443_) {
            return;
        }
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        if (world.f_46443_) {
            return;
        }
        HologramSourceBlock.updateNeighbourConnections(state, world, pos, false);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState p_60555_, @NotNull BlockGetter p_60556_, @NotNull BlockPos p_60557_, @NotNull CollisionContext p_60558_) {
        return COShapes.HOLOGRAM_SOURCE.get((Direction)p_60555_.m_61143_((Property)f_54117_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.m_7926_(p_49915_.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{CONNECTED_POSITIVE}).m_61104_(new Property[]{CONNECTED_NEGATIVE}));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)super.m_5573_(context).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
        return HologramSourceBlock.updateStateConnections(state, (BlockGetter)context.m_43725_(), context.m_8083_());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(interactionHand);
        if (!stack.m_41619_()) {
            HologramSourceBlockEntity be = (HologramSourceBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
            if (be == null) {
                return InteractionResult.PASS;
            }
            if (stack.m_150930_(AllItems.WRENCH.m_5456_())) {
                return super.m_6227_(state, level, pos, player, interactionHand, blockHitResult);
            }
            if ((be = be.getController()) == null) {
                return InteractionResult.PASS;
            }
            be.setItemStack(stack.m_41777_());
            return InteractionResult.SUCCESS;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.withBlockEntityDo((BlockGetter)level, pos, be -> this.displayScreen((HologramSourceBlockEntity)((Object)((Object)((Object)be))), player)));
        return InteractionResult.SUCCESS;
    }

    public Class<HologramSourceBlockEntity> getBlockEntityClass() {
        return HologramSourceBlockEntity.class;
    }

    public BlockEntityType<? extends HologramSourceBlockEntity> getBlockEntityType() {
        return (BlockEntityType)COBlockEntities.HOLOGRAM_SOURCE.get();
    }

    public static BlockState updateStateConnections(BlockState state, BlockGetter level, BlockPos pos) {
        boolean f1 = HologramSourceBlock.canConnect(state, level.m_8055_(pos.m_121945_(Direction.m_122387_((Direction.Axis)HologramSourceBlock.getConnectionAxis(state), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE))));
        boolean f2 = HologramSourceBlock.canConnect(state, level.m_8055_(pos.m_121945_(Direction.m_122387_((Direction.Axis)HologramSourceBlock.getConnectionAxis(state), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE))));
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        boolean f = direction.equals((Object)Direction.EAST) || direction.equals((Object)Direction.NORTH);
        BlockState state1 = (BlockState)state.m_61124_((Property)(f ? CONNECTED_NEGATIVE : CONNECTED_POSITIVE), (Comparable)Boolean.valueOf(f1));
        state1 = (BlockState)state1.m_61124_((Property)(f ? CONNECTED_POSITIVE : CONNECTED_NEGATIVE), (Comparable)Boolean.valueOf(f2));
        return state1;
    }

    protected static boolean canConnect(BlockState state, BlockState other) {
        return other.m_60734_() instanceof HologramSourceBlock && ((Direction)state.m_61143_((Property)f_54117_)).m_122434_() == ((Direction)other.m_61143_((Property)f_54117_)).m_122434_();
    }

    protected static Optional<HologramSourceBlockEntity> getConnection(BlockState state, BlockPos pos, Level level, Direction.AxisDirection axisDirection) {
        if (HologramSourceBlock.getConnectionAxis(state).m_122478_()) {
            return Optional.empty();
        }
        Optional<HologramSourceBlockEntity> op = Optional.ofNullable(COUtils.getBlockEntity((BlockGetter)level, pos.m_121945_(Direction.m_122387_((Direction.Axis)HologramSourceBlock.getConnectionAxis(state), (Direction.AxisDirection)axisDirection)), HologramSourceBlockEntity.class));
        if (op.isPresent()) {
            op = HologramSourceBlock.getConnectionAxis(op.get().m_58900_()).equals((Object)HologramSourceBlock.getConnectionAxis(state)) ? op : Optional.empty();
        }
        return op;
    }

    protected static Direction.Axis getConnectionAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)f_54117_)).m_122428_().m_122434_();
    }

    public static void updateNeighbourConnections(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, boolean onRemove) {
        ArrayList bes = new ArrayList();
        HologramSourceBlock.getConnection(state, pos, level, Direction.AxisDirection.POSITIVE).ifPresent(be -> {
            level.m_7731_(be.m_58899_(), HologramSourceBlock.updateStateConnections(be.m_58900_(), (BlockGetter)level, be.m_58899_()), 3);
            bes.add(be);
        });
        HologramSourceBlock.getConnection(state, pos, level, Direction.AxisDirection.NEGATIVE).ifPresent(be -> {
            level.m_7731_(be.m_58899_(), HologramSourceBlock.updateStateConnections(be.m_58900_(), (BlockGetter)level, be.m_58899_()), 3);
            bes.add(be);
        });
        if (!bes.isEmpty()) {
            if (onRemove) {
                bes.forEach(HologramSourceBlockEntity::onAdded);
            } else {
                ((HologramSourceBlockEntity)((HologramSourceBlock)state.m_60734_()).getBlockEntity((BlockGetter)level, pos)).onAdded();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(HologramSourceBlockEntity be, Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new HologramSourceScreen(be));
        }
    }

    public static <T extends Block> Function<BlockState, ModelFile> getBlockModel(DataGenContext<Block, T> c, RegistrateBlockstateProvider p) {
        return state -> AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{HologramSourceBlock.getNameForState(state)});
    }

    private static String getNameForState(BlockState state) {
        boolean f1 = (Boolean)state.m_61143_((Property)CONNECTED_POSITIVE);
        boolean f2 = (Boolean)state.m_61143_((Property)CONNECTED_NEGATIVE);
        return f1 && f2 ? "connected" : (f1 ? "connected_positive" : (f2 ? "connected_negative" : "not_connected"));
    }
}

